package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPopButtonProperties;

/**
 * 弹出视图按钮组件
 */
public class MetaPopButton extends MetaButton {

	public static final String TAG_NAME = ControlType.STR_POPBUTTON;

	/**
	 * 设置属性属性
	 * @param properties 属性对象
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaPopButtonProperties) properties;
	}

	@Override
	public MetaPopButtonProperties getProperties() {
		return (MetaPopButtonProperties) properties;
	}

	/**
	 * 获取弹出的视图的弹出方位
	 * @return 弹出方位 参考{@link com.bokesoft.yigo.common.def.PopButtonLocationType}
	 */
	public int getLocation() {
		return getProperties().getLocation();
	}

	/**
	 * 设置弹出视图的弹出方位
	 * @param location 弹出方位 参考{@link com.bokesoft.yigo.common.def.PopButtonLocationType} 
	 */
	public void setLocation(int location) {
		getProperties().setLocation(location);
	}

	/**
	 * 获取弹出视图根组件
	 * @return 弹出视图根组件
	 */
	public MetaComponent getRoot() {
		return getProperties().getRoot();
	}

	/**
	 * 设置弹出视图的根组件
	 * @param root 弹出视图根组件
	 */
	public void setRoot(MetaComponent root) {
		getProperties().setRoot(root);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.POPBUTTON;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPopButton newObj = (MetaPopButton) super.clone();
		newObj.setProperties(properties == null ? null : (MetaPopButtonProperties) getProperties().clone());
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPopButton();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(getProperties().getRoot() == null){
			throw new MetaException(MetaException.NO_ROOT_CONTROL, SimpleStringFormat.format(
					StringTable.getString(null, "", StringTable.NoRootControl),getKey()));
		}else{
			getProperties().getRoot().doPostProcess(flag, callback);
		}
	}
	
	@Override
	public MetaButtonProperties newProperties() {
		return new MetaPopButtonProperties();
	}
	
}
