package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;

public class MetaImageButton extends MetaButton {

	public static final String TAG_NAME = ControlType.STR_IMAGEBUTTON;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public int getControlType() {
		return ControlType.IMAGEBUTTON;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaImageButton newObject = (MetaImageButton)super.clone();
		newObject.setProperties((MetaButtonProperties) properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaImageButton();
	}
}
