package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHoverButtonProperties;

public class MetaHoverButton extends MetaButton{
	
	public static final String TAG_NAME = ControlType.STR_HOVERBUTTON;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 获取位置
	 * 
	 * @return 位置
	 */
	public int getLocation() {
		return ((MetaHoverButtonProperties)properties).getLocation();
	}
	
	/**
	 * 设置位置
	 * 
	 * @param location 位置
	 */
	public void setLocation(int location) {
		((MetaHoverButtonProperties)properties).setLocation(location);
	}
	
	@Override
	public int getControlType() {
		return ControlType.HOVERBUTTON;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHoverButton();
	}

	@Override
	public MetaButtonProperties newProperties() {
		return new MetaHoverButtonProperties();
	}
	
}
