package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFlatCanvasProperties;

/**
 * 平面图控件配置对象
 * 
 * @author chenbb
 *
 */
public class MetaFlatCanvas extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_FLATCANVAS;
	
	private MetaFlatCanvasProperties properties = new MetaFlatCanvasProperties();

	public MetaFlatCanvas() {
		super();
	}

	public void setSource(String source) {
		properties.setSource(source);
	}
	
	public String getSource() {
		return properties.getSource();
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.FLATCANVAS;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFlatCanvas();
	}

	public AbstractMetaObject clone() {
		MetaFlatCanvas newObject = (MetaFlatCanvas) super.clone();
		newObject.setProperties((MetaFlatCanvasProperties) properties.clone());
		return newObject;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaFlatCanvasProperties) properties;
	}

	@Override
	public MetaFlatCanvasProperties getProperties() {
		return properties;
	}

}