package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDateRangePickerProperties;

/**
 * 日期区间选择配置对象
 * 
 * @author 张健
 */
public class MetaDateRangePicker extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_DATERANGEPICKER;

	private MetaDateRangePickerProperties properties = new MetaDateRangePickerProperties();

/*	*//**
	 * 设置日期时间的显示格式
	 * 
	 * @param dateFormat
	 *            显示格式
	 *//*
	public void setDateFormat(String dateFormat) {
		this.properties.setDateFormat(dateFormat);
	}

	*//**
	 * 获取日期时间的显示格式
	 * 
	 * @return 显示格式
	 *//*
	public String getDateFormat() {
		return this.properties.getDateFormat();
	}

	*//**
	 * 设置是否仅保留日期部分
	 * 
	 * @param isOnlyDate
	 *            是否仅保留日期部分
	 *//*
	public void setOnlyDate(boolean isOnlyDate) {
		this.properties.setOnlyDate(isOnlyDate);
	}

	*//**
	 * 获取是否仅保留日期部分
	 * 
	 * @return 是否仅保留日期部分
	 *//*
	public Boolean isOnlyDate() {
		return this.properties.isOnlyDate();
	}*/

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.DATERANGEPICKER;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaDateRangePicker newObject = (MetaDateRangePicker)super.clone();
		newObject.setProperties((MetaDateRangePickerProperties)properties.clone());

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDateRangePicker();
	}

	@Override
	public MetaDateRangePickerProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaDateRangePickerProperties) properties;
	}
}
