package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.PopAnim;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.def.SelectStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;

/**
 * 多选下拉框配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaCheckListBox extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_CHECKLISTBOX;

	private MetaCheckListBoxProperties properties = new MetaCheckListBoxProperties();

	public MetaCheckListBox() {
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.CHECKLISTBOX;
	}

	/**
	 * 设置依赖字段定义
	 *
	 * @param dependency 依赖字段定义，用','分隔
	 */
	public void setItemsDependency(String dependency){
		this.properties.setItemsDependency(dependency);
	}
	
	/**
	 * 获取依赖字段定义
	 *
	 * @return 依赖字段定义，用','分隔
	 */
	public String getItemsDependency(){
		return this.properties.getItemsDependency();
	}
	
	/**
	 * 获取全局下拉项，仅{@link #getSourceType()}为{@link ComboBoxSourceType#FORMULA}时有效
	 *
	 * @return 全局下拉项
	 */
	public String getGlobalItems() {
		return this.properties.getGlobalItems();
	}

	/**
	 * 获取下拉项的总数，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @return 下拉项总数
	 */
	public int getItemCount() {
		return this.properties.getItemCount();
	}

	/**
	 * 获取特定位置的下拉项，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @param index 位置的序号
	 * @return 特定位置的下拉项
	 */
	public MetaDefaultItem getItem(int index) {
		return this.properties.getItem(index);
	}
	
	/**
	 * 设置下拉项集合，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @param items 下拉项集合
	 */
	public void setItems(MetaListBoxItemCollection items) {
		this.properties.setItems(items);
	}
	
	/**
	 * 获取下拉项集合，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @return 下拉项集合
	 */
	public MetaListBoxItemCollection getItems() {
		return this.properties.getItems();
	}
	
	/**
	 * 获取查询定义，仅{@link #getSourceType()}为{@link ComboBoxSourceType#QUERY}时有效
	 *
	 * @return 查询定义
	 */
	public MetaQueryDef getQueryDef(){
		return this.properties.getQueryDef();
	}
	
	/**
	 * 设置查询定义，仅{@link #getSourceType()}为{@link ComboBoxSourceType#QUERY}时有效
	 *
	 * @param queryDef 查询定义
	 */
	public void setQueryDef(MetaQueryDef queryDef){
		this.properties.setQueryDef(queryDef);
	}
	
	/**
	 * 获取来源类型
	 *
	 * @return 来源类型，取值范围为{@link ComboBoxSourceType}
	 */
	public Integer getSourceType(){
		return this.properties.getSourceType();
	}
	
	/**
	 * 设置来源类型
	 *
	 * @param type 来源类型，取值范围为{@link ComboBoxSourceType}
	 */
	public void setSourceType(Integer type){
		this.properties.setSourceType(type);
	}

	/**
	 * 设置文本为空时的提示信息
	 *
	 * @param promptText 文本为空时的提示信息
	 */
	public void setPromptText(String promptText) {
		properties.setPromptText(promptText);
	}

	/**
	 * 获取文本为空时的提示信息
	 *
	 * @return 文本为空时的提示信息
	 */
	public String getPromptText() {
		return properties.getPromptText();
	}

	/**
	 * 获取显示样式
	 *
	 * @return 显示样式，取值范围为{@link SelectStyle}
	 */
	public Integer getStyle() {
		return properties.getStyle();
	}

	/**
	 * 设置显示样式
	 *
	 * @param style 显示样式，取值范围为{@link SelectStyle}
	 */
	public void setStyle(Integer style) {
		properties.setStyle(style);
	}

	/**
	 * 获取编辑样式，仅{@link #getStyle()}为{@link SelectStyle#POP}时有效
	 *
	 * @return 编辑样式，取值范围为{@link SelectEditType}
	 */
	public Integer getEditType() {
		return properties.getEditType();
	}

	/**
	 * 设置编辑样式，仅{@link #getStyle()}为{@link SelectStyle#POP}时有效
	 *
	 * @param editType 编辑样式，取值范围为{@link SelectEditType}
	 */
	public void setEditType(Integer editType) {
		properties.setEditType(editType);
	}

	/**
	 * 获取平铺标签显示样式下的每行的列数，仅{@link #getStyle()}为{@link SelectStyle#TILED}时有效
	 *
	 * @return 平铺标签显示样式下的每行的列数
	 */
	public Integer getColumnCount() {
		return properties.getColumnCount();
	}

	/**
	 * 设置平铺标签显示样式下的每行的列数，仅{@link #getStyle()}为{@link SelectStyle#TILED}时有效
	 *
	 * @param columnCount 平铺标签显示样式下的每行的列数
	 */
	public void setColumnCount(Integer columnCount) {
		properties.setColumnCount(columnCount);
	}

	/**
	 * 获取参数组标识，仅{@link #getSourceType()}为{@link ComboBoxSourceType#PARAGROUP}时有效
	 *
	 * @return 参数组标识
	 */
	public String getGroupKey() {
		return properties.getGroupKey();
	}

	/**
	 * 设置参数组标识，仅{@link #getSourceType()}为{@link ComboBoxSourceType#PARAGROUP}时有效
	 *
	 * @param groupKey 参数组标识
	 */
	public void setGroupKey(String groupKey) {
		properties.setGroupKey(groupKey);
	}

	/**
	 * 获取弹出动画，仅{@link #getStyle()}为{@link SelectStyle#POP}或
	 * {@link SelectStyle#DROPDOWN}时有效
	 *
	 * @return 弹出动画，取值范围为{@link PopAnim}
	 */
	public String getPopAnim() {
		return properties.getPopAnim();
	}

	/**
	 * 设置弹出动画，仅{@link #getStyle()}为{@link SelectStyle#POP}或
	 * {@link SelectStyle#DROPDOWN}时有效
	 *
	 * @param popAnim 弹出动画，取值范围为{@link PopAnim}
	 */
	public void setPopAnim(String popAnim) {
		properties.setPopAnim(popAnim);
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaCheckListBox newObject = (MetaCheckListBox)super.clone();
		newObject.setProperties((MetaCheckListBoxProperties)properties.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCheckListBox();
	}

	@Override
	public MetaCheckListBoxProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaCheckListBoxProperties) properties;
	}
	
	/**
	 * 设置表达式下拉项
	 * @param formulaItems 脚本元数据
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.properties.setFormulaItems(formulaItems);
	}
	
	/**
	 * 取得表达式下拉项
	 * @return 脚本元数据
	 */
	public MetaBaseScript getFormulaItems() {
		return this.properties.getFormulaItems();
	}

	
	/**
	 * 添加class
	 * @return class
	 */
	public String getCssClass(){
		return this.properties.getCssClass();
	}
	
	/**
	 * 添加class
	 * @return class
	 */
	public void setCssClass(String cssClass){
		this.properties.setCssClass(cssClass);
	}
	
	/**
	 * 取得下拉项显示方式
	 * @return 下拉项显示方式
	 */
	public Integer getTextShowType(){
		return properties.getTextShowType();
	}
	
	/**
	 * 取得下拉项显示方式
	 * @param type 下拉项显示方式
	 */
	public void setTextShowType(Integer type){
		properties.setTextShowType(type);
	}
	
	/**
	 * 获取下拉项显示方式
	 * 
	 * @return
	 */
	public String getTextShowFormat(){
		return properties.getTextShowFormat();
	}
}
