package com.bokesoft.yigo.meta.form.component.control;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CarouselSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCarouselItemCollection;

/**
 * 跑马灯配置对象
 */
public class MetaCarousel extends MetaComponent {
	/** 点击事件 */	
	private MetaBaseScript onClick = null;
	/** 来源类型：固定项或表达式*/
	private Integer sourceType = CarouselSourceType.ITEMS;
	/** 固定下拉项集合*/
	private MetaCarouselItemCollection items = null;
	/** 表达式表示的下拉项集合 */
	private MetaBaseScript formulaItems = null;
	/** 显示指示点*/
	private Boolean showDots = true;
	/** 自动播放*/
	private Boolean autoplay = true;
	/** 自动播放间隔*/
	private Integer autoplayInterval = -1;
	/** 循环播放*/
	private Boolean infinite = true;
	
	public MetaCarousel() {
		super();
		items = new MetaCarouselItemCollection();
	}
	
	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}
	
	/**
	 * 设置来源类型
	 * @param sourceType 来源类型
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 获取来源类型
	 * @return 来源类型
	 */
	public Integer getSourceType() {
		return sourceType;
	}
	
	/**
	 * 设置下拉项集合
	 * @param items 下拉项集合
	 */
	public void setItems(MetaCarouselItemCollection items) {
		this.items = items;
	}
	
	/**
	 * 取得下拉项集合
	 * @return 下拉项集合
	 */
	public MetaCarouselItemCollection getItems() {
		return items;
	}
	
	/**
	 * 设置表达式下拉项
	 * @param formulaItems 脚本元数据
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.formulaItems = formulaItems;
	}
	
	/**
	 * 取得表达式下拉项
	 * @return 脚本元数据
	 */
	public MetaBaseScript getFormulaItems() {
		return this.formulaItems;
	}
	
	/**
	 * 设置是否显示指示点
	 * @param showDots 是否显示指示点
	 */
	public void setShowDots(Boolean showDots) {
		this.showDots = showDots;
	}
	
	/**
	 * 获取是否显示指示点
	 * @return 是否显示指示点
	 */
	public Boolean isShowDots() {
		return this.showDots;
	}
	
	/**
	 * 设置是否自动播放
	 * @param autoplay 是否自动播放
	 */
	public void setAutoplay(Boolean autoplay) {
		this.autoplay = autoplay;
	}
	
	/**
	 * 获取是否自动播放
	 * @return 是否自动播放
	 */
	public Boolean isAutoplay() {
		return this.autoplay;
	}
	
	/**
	 * 设置自动播放间隔
	 * 单位ms
	 * @param interval 自动播放间隔
	 */
	public void setAutoplayInterval(Integer interval) {
		this.autoplayInterval = interval;
	}
	
	/**
	 * 获取自动播放间隔
	 * @return 自动播放间隔
	 */
	public Integer getAutoplayInterval() {
		return this.autoplayInterval;
	}
	
	/**
	 * 设置是否循环播放
	 * @param infinite 是否循环播放
	 */
	public void setInfinite(Boolean infinite) {
		this.infinite = infinite;
	}
	
	/**
	 * 获取是否循环播放
	 * @return 是否循环播放
	 */
	public Boolean isInfinite() {
		return this.infinite;
	}
	
	@Override
	public int getControlType() {
		return ControlType.CAROUSEL;
	}

	public static final String TAG_NAME = ControlType.STR_CAROUSEL;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaCarousel newObject = (MetaCarousel)super.clone();
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setItems(items == null ? null : (MetaCarouselItemCollection)items.clone());
		newObject.setFormulaItems(formulaItems == null ? null : (MetaBaseScript)formulaItems.clone());
		newObject.setSourceType(sourceType);
		newObject.setShowDots(showDots);
		newObject.setAutoplay(autoplay);
		newObject.setAutoplayInterval(autoplayInterval);
		newObject.setInfinite(infinite);
		return newObject;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { items, formulaItems, onClick });
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		
		AbstractMetaObject resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( MetaConstants.CAROUSEL_FORMULAITEMS.equals(tagName) ) {
				this.formulaItems = new MetaBaseScript(MetaConstants.CAROUSEL_FORMULAITEMS);
				resultMetaObject = formulaItems;
			}else if ( MetaConstants.Event_OnClick.equals(tagName) ) {
				onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
				resultMetaObject = onClick;
			}
		}
		if(resultMetaObject == null){
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}

		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCarousel();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

}
