package com.bokesoft.yigo.meta.form.component;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaCustom extends MetaComponent {
	/** 定制组件的定制标志 */
	private String tag = "";
	/** 用户自定义数据 */
	private String userData = "";
	/** 自定义控件实现类 */
	private String impl = null;
	
	public MetaCustom() {
		super();
	}
	
	/**
	 * 设置定制标志
	 * @param tag 标志
	 */
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	/**
	 * 取得定制标志
	 * @return 标志
	 */
	public String getTag() {
		return this.tag;
	}
	
	/**
	 * 设置用户自定义数据
	 * @param userData 用户自定义数据
	 */
	public void setUserData(String userData) {
		this.userData = userData;
	}
	
	/**
	 * 取得用户自定义数据
	 * @return 用户自定义数据
	 */
	public String getUserData() {
		return this.userData;
	}
	
	/**
	 * 设置自定义实现类
	 * @param impl
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 获取自定义实现类
	 * @return
	 */
	public String getImpl(){
		return this.impl;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		return resultMetaObject;
	}
	
	@Override
	public int getControlType() {
		return ControlType.CUSTOM;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	public static final String TAG_NAME = ControlType.STR_CUSTOM;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustom();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCustom newObject = (MetaCustom)super.clone();
		newObject.setTag(tag);
		newObject.setUserData(userData);
		newObject.setImpl(impl);
		return newObject;
	}
}
