package com.bokesoft.yigo.meta.form.component;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaPopView;
import com.bokesoft.yigo.meta.form.component.bar.MetaMenuBar;
import com.bokesoft.yigo.meta.form.component.bar.MetaStatusBar;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.bar.MetaTreeMenuBar;
import com.bokesoft.yigo.meta.form.component.chart.MetaChart;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaAttachment;
import com.bokesoft.yigo.meta.form.component.control.MetaBPMGraph;
import com.bokesoft.yigo.meta.form.component.control.MetaBarCoder;
import com.bokesoft.yigo.meta.form.component.control.MetaBatchImageUploader;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaCalendar;
import com.bokesoft.yigo.meta.form.component.control.MetaCarousel;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckBox;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaColorPicker;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboView;
import com.bokesoft.yigo.meta.form.component.control.MetaCompDict;
import com.bokesoft.yigo.meta.form.component.control.MetaCountDownView;
import com.bokesoft.yigo.meta.form.component.control.MetaCountUp;
import com.bokesoft.yigo.meta.form.component.control.MetaDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaDateRangePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaDictPane;
import com.bokesoft.yigo.meta.form.component.control.MetaDictSearchBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDrawerBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDropdownButton;
import com.bokesoft.yigo.meta.form.component.control.MetaDynamicDict;
import com.bokesoft.yigo.meta.form.component.control.MetaEmpty;
import com.bokesoft.yigo.meta.form.component.control.MetaFileChooser;
import com.bokesoft.yigo.meta.form.component.control.MetaFlatCanvas;
import com.bokesoft.yigo.meta.form.component.control.MetaFontPicker;
import com.bokesoft.yigo.meta.form.component.control.MetaGIFImage;
import com.bokesoft.yigo.meta.form.component.control.MetaGridDesigner;
import com.bokesoft.yigo.meta.form.component.control.MetaHoverButton;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;
import com.bokesoft.yigo.meta.form.component.control.MetaIcon;
import com.bokesoft.yigo.meta.form.component.control.MetaImage;
import com.bokesoft.yigo.meta.form.component.control.MetaImageButton;
import com.bokesoft.yigo.meta.form.component.control.MetaImageList;
import com.bokesoft.yigo.meta.form.component.control.MetaLabel;
import com.bokesoft.yigo.meta.form.component.control.MetaMonthPicker;
import com.bokesoft.yigo.meta.form.component.control.MetaMultiStateButton;
import com.bokesoft.yigo.meta.form.component.control.MetaNoticeBar;
import com.bokesoft.yigo.meta.form.component.control.MetaNumberEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaNumberInfoEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaPasswordEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaPopButton;
import com.bokesoft.yigo.meta.form.component.control.MetaPriceLabel;
import com.bokesoft.yigo.meta.form.component.control.MetaProgressBar;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;
import com.bokesoft.yigo.meta.form.component.control.MetaRelativeTime;
import com.bokesoft.yigo.meta.form.component.control.MetaRichEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaScoreBar;
import com.bokesoft.yigo.meta.form.component.control.MetaSegmentedControl;
import com.bokesoft.yigo.meta.form.component.control.MetaSeparator;
import com.bokesoft.yigo.meta.form.component.control.MetaSlider;
import com.bokesoft.yigo.meta.form.component.control.MetaSplitButton;
import com.bokesoft.yigo.meta.form.component.control.MetaStepEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaSubForm;
import com.bokesoft.yigo.meta.form.component.control.MetaSwitch;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.MetaTextArea;
import com.bokesoft.yigo.meta.form.component.control.MetaTextButton;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaTimeCountDown;
import com.bokesoft.yigo.meta.form.component.control.MetaTimePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaTimeZoneDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaToggleButton;
import com.bokesoft.yigo.meta.form.component.control.MetaUTCDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaUploadButton;
import com.bokesoft.yigo.meta.form.component.control.MetaValidateBox;
import com.bokesoft.yigo.meta.form.component.control.MetaVideoPlayer;
import com.bokesoft.yigo.meta.form.component.control.MetaWebBrowser;
import com.bokesoft.yigo.meta.form.component.control.buttongroup.MetaButtonGroup;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionView;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGantt;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaListLayoutView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaGallery;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotator;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotatorList;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaTiledList;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaWaterFall;
import com.bokesoft.yigo.meta.form.component.control.map.MetaMapDraw;
import com.bokesoft.yigo.meta.form.component.control.moduleeditor.MetaModuleEditor;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationList;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressIndicator;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshControl;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaShrinkView;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.control.treeview.MetaTreeView;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardList;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.html.MetaHtml_A;
import com.bokesoft.yigo.meta.form.component.html.MetaHtml_H1;
import com.bokesoft.yigo.meta.form.component.html.MetaHtml_H2;
import com.bokesoft.yigo.meta.form.component.html.MetaHtml_P;
import com.bokesoft.yigo.meta.form.component.html.MetaHtml_UL;
import com.bokesoft.yigo.meta.form.component.panel.MetaBorderLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaColumnLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaGeneralPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaLinearLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaPagePanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSlidingLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaWizardPanel;
import com.bokesoft.yigo.meta.form.component.panel.FlexBoxPanel.MetaFlexBoxPanel;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapsePanel;
import com.bokesoft.yigo.meta.form.component.panel.customlayoutpanel.MetaCustomLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.flexgridpanel.MetaFlexGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.tablepanel.MetaFluidTableLayoutPanel;

public class MetaComponentFactory {
	private static MetaComponentFactory factory = null;

	public static MetaComponentFactory getInstance() {
		if (factory == null) {
			factory = new MetaComponentFactory();
		}
		return factory;
	}

	public MetaComponent newComponent(String tagName) throws MetaException {
		MetaComponent component = null;
		if (tagName.equalsIgnoreCase(MetaBlock.TAG_NAME)) {
			component = new MetaBlock();
		} else {
			int controlType = ControlType.parse(tagName);
			switch (controlType) {
			case ControlType.COLUMNLAYOUTPANEL:
				component = new MetaColumnLayoutPanel();
				break;
			case ControlType.GRIDLAYOUTPANEL:
				component = new MetaGridLayoutPanel();
				break;
			case ControlType.CUSTOMLAYOUTPANEL:
				component = new MetaCustomLayoutPanel();
				break;
			case ControlType.FLEXBOXPANEL:
				component = new MetaFlexBoxPanel();
				break;
			case ControlType.TABPANEL:
				component = new MetaTabPanel();
				break;
			case ControlType.COLLAPSEPANEL:
				component = new MetaCollapsePanel();
				break;
			case ControlType.CALENDAR:
				component = new MetaCalendar();
				break;
			case ControlType.PAGEPANEL:
				component = new MetaPagePanel();
				break;
			case ControlType.SPLITPANEL:
				component = new MetaSplitPanel();
				break;
			case ControlType.BORDERLAYOUTPANEL:
				component = new MetaBorderLayoutPanel();
				break;
			case ControlType.FLOWLAYOUTPANEL:
				component = new MetaFlowLayoutPanel();
				break;
			case ControlType.PANEL:
				component = new MetaGeneralPanel();
				break;
			case ControlType.FLUIDTABLELAYOUTPANEL:
				component = new MetaFluidTableLayoutPanel();
				break;
			case ControlType.WIZARDPANEL:
				component = new MetaWizardPanel();
				break;
			case ControlType.FLEXGRIDLAYOUTPANEL:
				component = new MetaFlexGridLayoutPanel();
				break;
			case ControlType.BUTTON:
				component = new MetaButton();
				break;
			case ControlType.NOTICEBAR:
				component = new MetaNoticeBar();
				break;
			case ControlType.BARCODER:
				component = new MetaBarCoder();
				break;
			case ControlType.TOGGLEBUTTON:
				component = new MetaToggleButton();
				break;
			case ControlType.CHECKBOX:
				component = new MetaCheckBox();
				break;
			case ControlType.CHECKLISTBOX:
				component = new MetaCheckListBox();
				break;
			case ControlType.COLORPICKER:
				component = new MetaColorPicker();
				break;
			case ControlType.COMBOBOX:
				component = new MetaComboBox();
				break;
			case ControlType.DATEPICKER:
				component = new MetaDatePicker();
				break;
			case ControlType.DATERANGEPICKER:
				component = new MetaDateRangePicker();
				break;
			case ControlType.MONTHPICKER:
				component = new MetaMonthPicker();
				break;
			case ControlType.TIMEPICKER:
				component = new MetaTimePicker();
				break;
			case ControlType.DICT:
				component = new MetaDict();
				break;
			case ControlType.COMPDICT:
				component = new MetaCompDict();
				break;
			case ControlType.DYNAMICDICT:
				component = new MetaDynamicDict();
				break;
			case ControlType.FONTPICKER:
				component = new MetaFontPicker();
				break;
			case ControlType.HYPERLINK:
				component = new MetaHyperLink();
				break;
			case ControlType.LABEL:
				component = new MetaLabel();
				break;
			case ControlType.PRICELABEL:
				component = new MetaPriceLabel();
				break;
			case ControlType.RELATIVETIME:
				component = new MetaRelativeTime();
				break;
			case ControlType.NUMBEREDITOR:
				component = new MetaNumberEditor();
				break;
			case ControlType.IMAGE:
				component = new MetaImage();
				break;
			case ControlType.VIDEOPLAYER:
				component = new MetaVideoPlayer();
				break;
			case ControlType.PROGRESSBAR:
				component = new MetaProgressBar();
				break;
			case ControlType.RADIOBUTTON:
				component = new MetaRadioButton();
				break;
			case ControlType.TEXTBUTTON:
				component = new MetaTextButton();
				break;
			case ControlType.TEXTEDITOR:
				component = new MetaTextEditor();
				break;
			case ControlType.LISTVIEW:
				component = new MetaListView();
				break;
			case ControlType.EDITVIEW:
				component = new MetaEditView();
				break;
			case ControlType.LISTLAYOUTVIEW:
				component = new MetaListLayoutView();
				break;
			case ControlType.GRID:
				component = new MetaGrid();
				break;
			case ControlType.MENUBAR:
				component = new MetaMenuBar();
				break;
			case ControlType.TOOLBAR:
				component = new MetaToolBar();
				break;
			case ControlType.TREEMENUBAR:
				component = new MetaTreeMenuBar();
				break;
			case ControlType.STATUSBAR:
				component = new MetaStatusBar();
				break;
			case ControlType.CONTAINER:
				component = new MetaContainer();
				break;
			case ControlType.FLEXFLOWLAYOUTPANEL:
				component = new MetaFlexFlowLayoutPanel();
				break;
			case ControlType.CHART:
				component = new MetaChart();
				break;
			case ControlType.TREEVIEW:
				component = new MetaTreeView();
				break;
			case ControlType.DICTVIEW:
				component = new MetaDictView();
				break;
			case ControlType.BUTTON_GROUP:
				component = new MetaButtonGroup();
				break;
			case ControlType.WEBBROWSER:
				component = new MetaWebBrowser();
				break;
			case ControlType.RICHEDITOR:
				component = new MetaRichEditor();
				break;
			case ControlType.PASSWORDEDITOR:
				component = new MetaPasswordEditor();
				break;
			case ControlType.SEPARATOR:
				component = new MetaSeparator();
				break;
			case ControlType.SPLITBUTTON:
				component = new MetaSplitButton();
				break;
			case ControlType.DROPDOWNBUTTON:
				component = new MetaDropdownButton();
				break;
			case ControlType.IMAGELIST:
				component = new MetaImageList();
				break;
			case ControlType.UPLOADBUTTON:
				component = new MetaUploadButton();
				break;
			case ControlType.BPM_GRAPH:
				component = new MetaBPMGraph();
				break;
			case ControlType.FLATCANVAS:
				component = new MetaFlatCanvas();
				break;
			case ControlType.ATTACHMENT:
				component = new MetaAttachment();
				break;
			case ControlType.TEXTAREA:
				component = new MetaTextArea();
				break;
			case ControlType.SUBFORM:
				component = new MetaSubForm();
				break;
			case ControlType.FILECHOOSER:
				component = new MetaFileChooser();
				break;
			case ControlType.GRIDDESIGNER:
				component = new MetaGridDesigner();
				break;
			case ControlType.UTCDATEPICKER:
				component = new MetaUTCDatePicker();
				break;
			case ControlType.ROTATOR:
				component = new MetaRotator();
				break;
			case ControlType.GALLERY:
				component = new MetaGallery();
				break;
			case ControlType.TILEDLIST:
				component = new MetaTiledList();
				break;
			case ControlType.WATERFALL:
				component = new MetaWaterFall();
				break;
			case ControlType.ROTATORLIST:
				component = new MetaRotatorList();
				break;
			case ControlType.TABLEVIEW:
				component = new MetaTableView();
				break;
			case ControlType.COLLECTIONVIEW:
				component = new MetaCollectionView();
				break;

			case ControlType.HTML_ELEMENT_UL:
				component = new MetaHtml_UL();
				break;
			case ControlType.HTML_ELEMENT_P:
				component = new MetaHtml_P();
				break;
			case ControlType.HTML_ELEMENT_A:
				component = new MetaHtml_A();
				break;
			case ControlType.HTML_ELEMENT_H1:
				component = new MetaHtml_H1();
				break;
			case ControlType.HTML_ELEMENT_H2:
				component = new MetaHtml_H2();
				break;
			case ControlType.SUBDETAIL:
				component = new MetaSubDetail();
				break;
			case ControlType.CUSTOM:
				component = new MetaCustom();
				break;
			case ControlType.MAP:
				component = new MetaMapDraw();
				break;
			case ControlType.LINEARLAYOUTPANEL:
				component = new MetaLinearLayoutPanel();
				break;
			case ControlType.SLIDINGLAYOUTPANEL:
				component = new MetaSlidingLayoutPanel();
				break;
			case ControlType.NAVIGATIONLIST:
				component = new MetaNavigationList();
				break;
			case ControlType.MODULEEDITOR:
				component = new MetaModuleEditor();
				break;
			case ControlType.EMBED:
				component = new MetaEmbed();
				break;
			case ControlType.FRAME:
				component = new MetaFrame();
				break;
			case ControlType.TABGROUP:
				component = new MetaTabGroup();
				break;
			case ControlType.STEPEDITOR:
				component = new MetaStepEditor();
				break;
			case ControlType.POPVIEW:
				component = new MetaPopView();
				break;
			case ControlType.SEGMENTEDCONTROL:
				component = new MetaSegmentedControl();
				break;
			case ControlType.WIZARDLIST:
				component = new MetaWizardList();
				break;
			case ControlType.REFRESHCONTROL:
				component = new MetaRefreshControl();
				break;
			case ControlType.GANTT:
				component = new MetaGantt();
				break;
			case ControlType.ICON:
				component = new MetaIcon();
				break;
			case ControlType.IMAGEBUTTON:
				component = new MetaImageButton();
				break;
			case ControlType.SCOREBAR:
				component = new MetaScoreBar();
				break;
			case ControlType.SWITCH:
				component = new MetaSwitch();
				break;
			case ControlType.POPBUTTON:
				component = new MetaPopButton();
				break;
			case ControlType.SLIDER:
				component = new MetaSlider();
				break;
			case ControlType.COUNTDOWNVIEW:
				component = new MetaCountDownView();
				break;
			case ControlType.COUNTUP:
				component = new MetaCountUp();
				break;
			case ControlType.NUMBERINFOEDITOR:
				component = new MetaNumberInfoEditor();
				break;
			case ControlType.PROGRESSINDICATOR:
				component = new MetaProgressIndicator();
				break;
			case ControlType.SHRINKVIEW:
				component = new MetaShrinkView();
				break;
			case ControlType.GIFIMAGE:
				component = new MetaGIFImage();
				break;
			case ControlType.VALIDATEBOX:
				component = new MetaValidateBox();
				break;
			case ControlType.TIMEZONEDATEPICKER:
				component = new MetaTimeZoneDatePicker();
				break;
			case ControlType.EMPTY:
				component = new MetaEmpty();
				break;
			case ControlType.CAROUSEL:
				component = new MetaCarousel();
				break;
			case ControlType.BATCHIMAGEUPLOADER:
				component = new MetaBatchImageUploader();
				break;
			case ControlType.MULTISTATEBUTTON:
				component = new MetaMultiStateButton();
				break;
			case ControlType.COMBOVIEW:
				component = new MetaComboView();
				break;
			case ControlType.DICTPANE:
				component = new MetaDictPane();
				break;
			case ControlType.DICTSEARCHBOX:
				component = new MetaDictSearchBox();
				break;
			case ControlType.TIMECOUNTDOWN:
				component = new MetaTimeCountDown();
				break;
			case ControlType.HOVERBUTTON:
				component = new MetaHoverButton();
				break;
			case ControlType.DRAWERBOX:
				component = new MetaDrawerBox();
				break;
			default:
				throw new MetaException(MetaException.UNSUPPORTED_TAG_NAME, SimpleStringFormat
						.format(StringTable.getString(null, "", StringTable.UnsupportedTagName), tagName));
			}
		}
		return component;
	}

}
