package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 表单数据源关系
 * 暂时用于复合字典，确定字典数据源对应显示的界面
 * @author zhufw
 *
 */
public class MetaFormRelation extends AbstractMetaObject {
	/**
	 * 表单key
	 */
	private String formKey = "";
	
	/**
	 * 数据源key
	 */
	private String dataObjectKey = "";
	
	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = "FormRelation";
	
	/**
	 * 设置表单key
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey){
		this.formKey = formKey;
	}
	
	/**
	 * 获取表单key
	 * @return 表单标识
	 */
	public String getFormKey(){
		return this.formKey;
	}
	
	/**
	 * 设置数据对象key
	 * @param dataObjectKey 数据对象标识
	 */
	public void setDataObjectKey(String dataObjectKey){
		this.dataObjectKey = dataObjectKey;
	}
	
	/**
	 * 获取数据对象key
	 * @return 数据对象标识
	 */
	public String getDataObjectKey(){
		return this.dataObjectKey;
	}
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFormRelation clone = new MetaFormRelation();
		clone.setFormKey(formKey);
		clone.setDataObjectKey(dataObjectKey);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFormRelation();
	}

	
}
