package com.bokesoft.yigo.meta.form;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;
import java.util.Stack;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.struct.report.MultiDimNode;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.process.MetaBuddyProcess;
import com.bokesoft.yes.meta.process.MetaGridWildcardProcess;
import com.bokesoft.yes.meta.process.MetaSubDetailProcess;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.ScreenOrientation;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableViewRowType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaExtendCollection;
import com.bokesoft.yigo.meta.common.MetaKeyHandlerCollection;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.common.MetaServiceRightsCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBarItemCollection;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaAttachment;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaComboView;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;
import com.bokesoft.yigo.meta.form.component.control.MetaImage;
import com.bokesoft.yigo.meta.form.component.control.MetaImageList;
import com.bokesoft.yigo.meta.form.component.control.MetaPopButton;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionView;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRow;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRowCollection;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaListLayoutView;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayout;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayoutCollection;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshControl;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaCollapseView;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaOperationBar;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaShrinkView;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaToolBarCollapse;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaToolBarExpand;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRowCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.*;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeDef;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeGroup;
import com.bokesoft.yigo.meta.form.component.i18n.MetaI18n;
import com.bokesoft.yigo.meta.form.component.i18n.MetaI18nItem;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapseCollection;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapseItem;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapsePanel;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.meta.util.MetaAnnotationUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * <p>
 * 窗口配置对象类，是从配置文件中读取生成的一个完整的界面结构 <br>
 * 包含：数据源配置对象（MetaDataSource)、操作定义集合（MetaOperationCollection)
 * 和组件对象集合（MetaComponentCollection) <br>
 * <p>
 *
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaForm extends AbstractMetaObject implements IPropertyMerger<MetaForm> {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/** 配置文件中对应片段的起始标签名称 */
	public static final String TAG_NAME = "Form";

	/** 窗口配置对象的标识 */
	private String key = "";

	/** 别名标识 */
	private String aliasKey = "";

	/** 表单使用的模板标识 */
	private String templateKey = "";

	/** 窗口配置对象的说明 */
	private String caption = "";

	/** 窗口配置对象的英文说明 */
	private String captionEn = "";

	/** 表单的表达式名称 */
	private String formulaCaption = "";

	/** 表单的缩写名称 */
	private String abbrCaption = "";

	/** 表单的表达式缩写名称 */
	private String formulaAbbrCaption = "";

	/** 表单从菜单树打开的状态,-1代表未定义 */
	private Integer initState = OperationState.Edit;

	/** 表单的类型,不继承 */
	private Integer formType = FormType.Normal;

	/** 支持的平台列表 */
	private Integer platform = PlatformType.All;

	/** 窗口的数据源配置对象 */
	private MetaDataSource dataSource = null;

	/** 窗口的操作定义集合 */
	private MetaOperationCollection optCollection = null;

	/** 脚本集合 */
	private MetaScriptCollection scriptCollection = null;

	/** 按键事件 */
	private MetaKeyHandlerCollection keyHandlerCollection = null;

	/** 查询集合 */
	private MetaQueryCollection queryCollection = null;

	/** 界面检查规则集合 */
	private MetaUICheckRuleCollection uiCheckRuleCollection = null;

	/** 参数集定义 */
	private MetaFormParaCollection formParaCollection = null;

	/** 数据绑定集合 */
	private MetaDataBindingCollection dataBindingCollection = null;

	/** 当前表单的动态单元格配置*/
	private MetaCellTypeGroup typeGroup = null;

	/** 表单窗体对象 */
	private MetaBody metaBody = null;

	/** 对工程的引用 */
	private transient IMetaProject project = null;

	/** 工程标识 */
	private String projectKey = "";

	/** OnLoad事件定义 */
	private MetaBaseScript onLoad = null;

	/** OnClose事件定义 */
	private MetaBaseScript onClose = null;

	/** onPostDataLoad事件定义 使用onPostShow */
	@Deprecated
	private MetaBaseScript onPostDataLoad = null;

	/** onPostShow事件定义 */
	private MetaBaseScript onPostShow = null;

	/** 是否认证登录 */
	private Boolean authenticate = true;

	/** 是否需要初始化焦点 --非配置对象*/
	private boolean initFocus = true;

	/** 维度数据提供者*/
	private String dimValueProvider = "";

	/** 是否启用表单变体*/
	private Boolean useVariant = false;

	/** 变体配置*/
	private MetaVariant variant = null;

	/** 扩展类集合 */
	private MetaExtendCollection extendCollection = null;

	/** 宏公式集合 */
	private MetaMacroCollection macroCollection = null;

	/** 定时器集合 */
	private MetaTimerTaskCollection timerTaskCollection = null;

	/** 数据源表单关系（复合字典用） */
	private MetaFormRelationCollection formRelationCollection = null;

	/** 权限代理 */
	private MetaRightsProxyCollection rightsProxyCollection = null;

	/** 表单内部的语言配置 */
	private HashMap<String, HashMap<String, String>> localeMap = null;

	// 单元格与组件的key不重复!

	/** 组件映射集合 */
	private StringHashMap<MetaComponent> componentMap = null;

	/** 单元格映射集合 */
	private StringHashMap<MetaGridCell> cellMap = null;

	/** 列表列映射集合 */
	private StringHashMap<MetaListViewColumn> listViewColumnMap = null;

	/** 编辑视图列映射集合 */
	private StringHashMap<MetaEditViewColumn> editViewColumnMap = null;

	/** TableView明细单元组件映射集合 */
	private StringHashMap<MetaComponent> detailCompMap = null;

	/** TableRow映射集合 */
	private StringHashMap<MetaTableRow> tableRowMap = null;

	/** 模板映射,给表单继承使用 */
	private StringHashMap<MetaEmbed> embedMap = null;

	/** 组件绑定集合 */
	private MetaFormBindingMap bindingMap = new MetaFormBindingMap();

	/** 子明细集合 */
	private List<MetaComponent> subDetails = null;

	/** 资源所在目录 */
	private String path = null;

	/** 资源全路径 */
	private String resource = null;

	/** 表单是否已经打开 */
	private Boolean formDisplay = false;

	/** 继承的表单标识 */
	private String extend = "";

	/** 关联的View */
	private String viewKey = "";

	/** 关联表单Key */
	private String linkedFormKey = "";

	/** 描述 */
	private String description = "";

	/** 屏幕横竖屏 */
	private Integer screenOrientation = ScreenOrientation.unspecified;

	/** 弹框关闭 */
	private Boolean confirmClose = true;

	/** 移动端使用，导航条设置 */
	private MetaNavigationBar navigation;
	/** 事件处理集合 */
	private MetaEventHandlerCollection eventHandlerCollection;
	/** 计算表达式集合 */
	private MetaUICalcExprCollection calcExprCollection = null;
	/** 是否持有导航条 */
	private String hasNavigationBar = "";
	/** 全屏类型 */
	private int fullScreenType = -1;
	/** 表单转场动画类型 */
	private String animationType = "";
	/** 字符串表 */
	private MetaStringTable strings = null;
	/** 弹框关闭 */
	private Boolean disableKeyboard;
	/** 动画定义合集 */
	private MetaAnimCollection animCollection = null;
	/** 表单服务权限集合 */
	private MetaServiceRightsCollection serviceRightsCollection = null;
	/** 配置版本 */
	private Integer version = 0;
	/** 用户自定义数据 */
	private String userData = "";
	/** 合并至源单*/
	private Boolean mergeToSource = false;
	/** 状态栏颜色，移动端使用 */
	private String statusBarColor;
	/** 是否离线表单，移动端使用 */
	private Boolean offLine = false;

	/** 移动使用，集合整个表单内所有组件设置的promptImage属性值，用于移动端打开界面时预先进行下载*/
	private ArrayList<String> promptImages = null;

	/** 水印，移动端使用 */
	private MetaWatermark watermark;

	/** 系统自动生成标识 */
	private boolean autoGen = false;

	/** 多语言表单 */
	private boolean i18n = false;
	/** 扩展表单使用，指向源表单标识 */
	private String sourceForm;

	/**
	 *  交付类
	 */
	private String deliveryClass = null;

	/**
	 *  传输关联FormKey
	 */
	private String transFormKey = null;

	public MetaForm() {
		super();
		this.cellMap = StringHashMap.newInstance();
		this.listViewColumnMap = StringHashMap.newInstance();
		this.editViewColumnMap = StringHashMap.newInstance();
		this.detailCompMap = StringHashMap.newInstance();
		this.embedMap = StringHashMap.newInstance();
		this.componentMap = StringHashMap.newInstance();
		this.localeMap = new HashMap<String, HashMap<String, String>>();
		this.subDetails = new ArrayList<>();
		this.promptImages = new ArrayList<>();
		this.tableRowMap = StringHashMap.newInstance();
	}

	public StringHashMap<MetaComponent> getComponentMap() {
		return componentMap;
	}

	public void setComponentMap(StringHashMap<MetaComponent> componentMap) {
		this.componentMap = componentMap;
	}

	public ArrayList<String> getPromptImages(){
		return this.promptImages;
	}

	public void setPromptImages(ArrayList<String> promptImages){
		this.promptImages = promptImages;
	}

	public void setMetaNavigation(MetaNavigationBar navigation) {
		this.navigation = navigation;
	}

	public MetaNavigationBar getMetaNavigation() {
		return navigation;
	}

	public void setNavigation(MetaNavigationBar navigation) {
		this.navigation = navigation;
	}

	public MetaTable getMetaTable(String tableKey) {
		if (dataSource == null || dataSource.getDataObject() == null) {
			return null;
		}
		return this.dataSource.getDataObject().getMetaTable(tableKey);
	}

	@Override
	public boolean needCheckExtend() {
		return true;
	}

	public Integer getScreenOrientation() {
		return screenOrientation;
	}

	public void setScreenOrientation(Integer screenOrientation) {
		this.screenOrientation = screenOrientation;
	}

	/**
	 * 获取表单是否已经被打开的标志
	 *
	 * @return 标志
	 */
	public Boolean isFormDisplay() {
		return formDisplay;
	}

	/**
	 * 设置表单是否已经被打开
	 *
	 * @param formDisplay
	 *            标志
	 */
	public void setFormDisplay(Boolean formDisplay) {
		this.formDisplay = formDisplay;
	}

	/**
	 * 获取表单的初始状态
	 *
	 * @return 初始状态
	 */
	public Integer getInitState() {
		return initState;
	}

	/**
	 * 设置表单的打开状态
	 *
	 * @param initState
	 *            初始状态
	 */
	public void setInitState(Integer initState) {
		this.initState = initState;
	}

	/**
	 * 获取窗口配置对象的标识
	 *
	 * @return 窗口配置对象的标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置窗口配置对象的标识
	 *
	 * @param key
	 *            标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置别名标识
	 *
	 * @param aliasKey
	 *            别名标识
	 */
	public void setAliasKey(String aliasKey) {
		this.aliasKey = aliasKey;
	}

	/**
	 * 取得别名标识
	 *
	 * @return 别名标识
	 */
	public String getAliasKey() {
		return this.aliasKey;
	}

	/**
	 * 设置模板标识
	 *
	 * @param templateKey
	 *            模板标识
	 */
	public void setTemplateKey(String templateKey) {
		this.templateKey = templateKey;
	}

	/**
	 * 获取模板标识
	 *
	 * @return 模板标识
	 */
	public String getTemplateKey() {
		return templateKey;
	}

	/**
	 * 获取主表单的KEY
	 *
	 * @return 主表单标识
	 */
	public String getMainFormKey() {
		return (aliasKey != null && !aliasKey.isEmpty()) ? aliasKey : key;
	}

	/**
	 * 获取窗口配置对象的名称
	 *
	 * @return 名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置窗口配置对象的名称
	 *
	 * @param caption
	 *            名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 获取窗口配置对象的英文名称
	 *
	 * @return 英文名称
	 */
	public String getCaptionEn() {
		return captionEn;
	}

	/**
	 * 设置窗口配置对象的英文名称
	 *
	 * @param captionEn
	 *            英文名称
	 */
	public void setCaptionEn(String captionEn) {
		this.captionEn = captionEn;
	}

	/**
	 * 表单的表达式名称
	 *
	 * @param formulaCaption
	 *            表达式
	 */
	public void setFormulaCaption(String formulaCaption) {
		this.formulaCaption = formulaCaption;
	}

	/**
	 * 取得表单的表达式名称
	 *
	 * @return 表达式
	 */
	public String getFormulaCaption() {
		return this.formulaCaption;
	}

	/**
	 * 设置表单的缩写名称
	 *
	 * @param abbrCaption
	 *            表单的缩写名称
	 */
	public void setAbbrCaption(String abbrCaption) {
		this.abbrCaption = abbrCaption;
	}

	/**
	 * 取得表单的缩写名称
	 *
	 * @return 表单的缩写名称
	 */
	public String getAbbrCaption() {
		return this.abbrCaption;
	}

	/**
	 * 设置表达式缩写名称
	 *
	 * @param formulaAbbrCaption
	 *            表达式缩写名称
	 */
	public void setFormulaAbbrCaption(String formulaAbbrCaption) {
		this.formulaAbbrCaption = formulaAbbrCaption;
	}

	/**
	 * 取得表达式缩写名称
	 *
	 * @return 表达式缩写名称
	 */
	public String getFormulaAbbrCaption() {
		return this.formulaAbbrCaption;
	}

	/**
	 * 设置支持的平台列表
	 *
	 * @param platform
	 *            平台标识列表
	 */
	public void setPlatform(Integer platform) {
		this.platform = platform;
	}

	/**
	 * 取得支持的平台列表
	 *
	 * @return 平台标识列表
	 */
	public Integer getPlatform() {
		return this.platform;
	}

	/**
	 * 设置窗口的数据源对象
	 *
	 * @param dataSource
	 *            数据源对象
	 */
	public void setDataSource(MetaDataSource dataSource) {
		this.dataSource = dataSource;
	}

	/**
	 * 获取窗口的数据源对象
	 *
	 * @return 数据源对象
	 */
	public MetaDataSource getDataSource() {
		return dataSource;
	}

	/**
	 * 设置窗口的操作定义集合
	 *
	 * @param optCollection
	 *            操作定义集合
	 */
	public void setOperationCollection(MetaOperationCollection optCollection) {
		this.optCollection = optCollection;
	}

	/**
	 * 获取窗口的操作定义集合
	 *
	 * @return 操作定义集合
	 */
	public MetaOperationCollection getOperationCollection() {
		return optCollection;
	}

	/**
	 * 取得查询语句集合
	 *
	 * @return 查询语句集合
	 */
	public MetaQueryCollection getQueryCollection() {
		return this.queryCollection;
	}

	/**
	 * 设置查询语句集合
	 *
	 * @param queryCollection
	 *            查询语句集合
	 */
	public void setQueryCollection(MetaQueryCollection queryCollection) {
		this.queryCollection = queryCollection;
	}

	/**
	 * 设置脚本集合
	 *
	 * @param scriptCollection
	 *            脚本集合
	 */
	public void setScriptCollection(MetaScriptCollection scriptCollection) {
		this.scriptCollection = scriptCollection;
	}

	/**
	 * 取得脚本集合
	 *
	 * @return 脚本集合
	 */
	public MetaScriptCollection getScriptCollection() {
		return this.scriptCollection;
	}

	/**
	 * 获取加载脚本
	 */
	public MetaScript getLoadScript() throws Throwable {
		return scriptCollection == null ? null : scriptCollection.getLoad();
	}

	/**
	 * 获取保存脚本
	 */
	public MetaScript getSaveScript() throws Throwable {
		return scriptCollection == null ? null : scriptCollection.getSave();
	}

	/**
	 * 获取按键事件
	 *
	 * @return 事件
	 */
	public MetaKeyHandlerCollection getKeyHandlerCollection() {
		return keyHandlerCollection;
	}

	/**
	 * 设置按键事件
	 *
	 * @param keyHandlerCollection
	 *            事件
	 */
	public void setKeyHandlerCollection(MetaKeyHandlerCollection keyHandlerCollection) {
		this.keyHandlerCollection = keyHandlerCollection;
	}

	/**
	 * 设置界面检查规则集合
	 *
	 * @param uiCheckRuleCollection
	 *            界面检查规则集合
	 */
	public void setUICheckRuleCollection(MetaUICheckRuleCollection uiCheckRuleCollection) {
		this.uiCheckRuleCollection = uiCheckRuleCollection;
	}

	/**
	 * 取得界面检查规则集合
	 *
	 * @return 界面检查规则集合
	 */
	public MetaUICheckRuleCollection getUICheckRuleCollection() {
		return this.uiCheckRuleCollection;
	}

	/**
	 * 设置数据绑定集合
	 *
	 * @param dataBindingCollection
	 *            数据绑定集合
	 */
	public void setDataBindingCollection(MetaDataBindingCollection dataBindingCollection) {
		this.dataBindingCollection = dataBindingCollection;
	}

	/**
	 * 取得数据绑定集合
	 *
	 * @return 数据绑定集合
	 */
	public MetaDataBindingCollection getDataBindingCollection() {
		return this.dataBindingCollection;
	}

	/**
	 * 设置窗口的控件对象集合
	 *
	 * @param metaBody
	 *            控件对象集合
	 */
	public void setMetaBody(MetaBody metaBody) {
		this.metaBody = metaBody;
	}

	/**
	 * 获取窗口的控件对象集合
	 *
	 * @return 控件对象集合
	 */
	public MetaBody getMetaBody() {
		return metaBody;
	}

	/**
	 * 设置工程引用
	 *
	 * @param project
	 *            工程引用的接口
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
		if(project != null){
			this.projectKey = project.getKey();
		}
	}

	/**
	 * 获取工程引用
	 *
	 * @return 工程引用接口
	 */
	public IMetaProject getProject() {
		return project;
	}

	/**
	 * 获取工程标识
	 *
	 * @return
	 */
	public String getProjectKey() {
		return projectKey;
	}

	/**
	 * 设置工程标识
	 *
	 * @param projectKey
	 */
	public void setProjectKey(String projectKey) {
		this.projectKey = projectKey;
	}

	/**
	 * 是否需要初始化焦点
	 *
	 * @return 是否需要初始化焦点
	 */
	public boolean initFocus() {
		return initFocus;
	}

	/**
	 * 设置是否需要初始化焦点
	 *
	 * @param initFocus
	 *            是否需要初始化焦点
	 */
	public void setInitFocus(boolean initFocus) {
		this.initFocus = initFocus;
	}

	/**
	 * 是否启用变体数据
	 *
	 * @return
	 */
	public boolean isUseVariant() {
		return useVariant;
	}

	/**
	 * 设置是否启用变体数据
	 *
	 * @param useVariant
	 */
	public void setUseVariant(Boolean useVariant) {
		this.useVariant = useVariant;
	}

	/**
	 * 获取维度数据提供者
	 * @return
	 */
	public String getDimValueProvider() {
		return dimValueProvider;
	}

	/**
	 * 设置维度数据提供者
	 * @param dimValueProvider
	 */
	public void setDimValueProvider(String dimValueProvider) {
		this.dimValueProvider = dimValueProvider;
	}

	/**
	 * 获取变体配置
	 *
	 * @return
	 */
	public MetaVariant getVariant() {
		return variant;
	}

	/**
	 * 设置变体配置
	 *
	 * @param variant
	 */
	public void setVariant(MetaVariant variant) {
		this.variant = variant;
	}

	/**
	 * 取得OnLoad事件定义
	 *
	 * @return 返回onLoad事件元数据描述，无定义时返回null
	 */
	public MetaBaseScript getOnLoad() {
		return onLoad;
	}

	/**
	 * 设置OnLoad事件定义
	 *
	 * @param onLoad
	 *            事件元数据
	 */
	public void setOnLoad(MetaBaseScript onLoad) {
		this.onLoad = onLoad;
	}

	/**
	 * 设置OnClose事件
	 *
	 * @param onClose
	 *            事件定义
	 */
	public void setOnClose(MetaBaseScript onClose) {
		this.onClose = onClose;
	}

	/**
	 * 取得OnClose事件
	 *
	 * @return 返回OnClose定义，无定义则返回null
	 */
	public MetaBaseScript getOnClose() {
		return this.onClose;
	}

	@Deprecated
	public MetaBaseScript getOnPostDataLoad() {
		return onPostDataLoad;
	}

	@Deprecated
	public void setOnPostDataLoad(MetaBaseScript onPostDataLoad) {
		this.onPostDataLoad = onPostDataLoad;
	}

	public MetaBaseScript getOnPostShow() {
		return this.onPostShow;
	}

	public void setOnPostShow(MetaBaseScript onPostShow) {
		this.onPostShow = onPostShow;
	}

	/**
	 * 设置表单类型
	 *
	 * @param formType
	 *            表单类型
	 * @see FormType
	 */
	public void setFormType(Integer formType) {
		this.formType = formType;
	}

	/**
	 * 取得表单类型
	 *
	 * @return 表单类型
	 * @see FormType
	 */
	public Integer getFormType() {
		return this.formType;
	}

	/**
	 * 设置是否需要认证登录属性
	 *
	 * @param authenticate
	 *            标记
	 */
	public void setAuthenticate(Boolean authenticate) {
		this.authenticate = authenticate;
	}

	/**
	 * 取得是否需要认证登录属性
	 *
	 * @return 标记
	 */
	public Boolean isAuthenticate() {
		return this.authenticate;
	}

	/**
	 * 设置扩展类集合
	 *
	 * @param extendCollection
	 *            扩展类集合
	 */
	public void setExtendCollection(MetaExtendCollection extendCollection) {
		this.extendCollection = extendCollection;
	}

	/**
	 * 取得扩展类集合
	 *
	 * @return 扩展类集合
	 */
	public MetaExtendCollection getExtendCollection() {
		return this.extendCollection;
	}

	/**
	 * 设置宏公式集合
	 *
	 * @param macroCollection
	 *            宏公式集合
	 */
	public void setMacroCollection(MetaMacroCollection macroCollection) {
		this.macroCollection = macroCollection;
	}

	/**
	 * 取得宏公式集合
	 *
	 * @return 宏公式集合
	 */
	public MetaMacroCollection getMacroCollection() {
		return this.macroCollection;
	}

	/**
	 * 设置资源所在目录
	 *
	 * @param path
	 *            目录
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * 取得资源所在目录
	 *
	 * @return 目录
	 */
	public String getPath() {
		return this.path;
	}

	/**
	 * 设置资源全路径
	 *
	 * @param resource
	 *            资源全路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}

	/**
	 * 取得资源全路径
	 *
	 * @return 资源全路径
	 */
	public String getResource() {
		return this.resource;
	}

	/**
	 * 设置定时任务集合
	 *
	 * @param timerTaskCollection
	 *            定时任务集合
	 */
	public void setTimerTaskCollection(MetaTimerTaskCollection timerTaskCollection) {
		this.timerTaskCollection = timerTaskCollection;
	}

	/**
	 * 取得定时任务集合
	 *
	 * @return 定时任务集合
	 */
	public MetaTimerTaskCollection getTimerTaskCollection() {
		return this.timerTaskCollection;
	}

	/**
	 * 设置表单参数集定义
	 *
	 * @param formParaCollection
	 *            表单参数集定义
	 */
	public void setFormParaCollection(MetaFormParaCollection formParaCollection) {
		this.formParaCollection = formParaCollection;
	}

	/**
	 * 取得表单参数集定义
	 *
	 * @return 表单参数集定义
	 */
	public MetaFormParaCollection getFormParaCollection() {
		return this.formParaCollection;
	}

	/**
	 * 获取权限代理定义集合
	 *
	 * @return 权限代理定义集合
	 */
	public MetaRightsProxyCollection getRightsProxyCollection() {
		return rightsProxyCollection;
	}

	/**
	 * 设置权限代理集合
	 *
	 * @param rightsProxyCollection
	 *            权限代理定义集合
	 */
	public void setRightsProxyCollection(MetaRightsProxyCollection rightsProxyCollection) {
		this.rightsProxyCollection = rightsProxyCollection;
	}

	/**
	 * 获取表单数据源关系
	 *
	 * @return 表单数据源关系
	 */
	public MetaFormRelationCollection getFormRelationCollection() {
		return this.formRelationCollection;
	}

	/**
	 * 设置表单数据源关系
	 *
	 * @param formRelation
	 *            表单数据源关系
	 */
	public void setFormRelationCollection(MetaFormRelationCollection formRelation) {
		this.formRelationCollection = formRelation;
	}

	/**
	 * 设置描述
	 *
	 * @param description
	 *            描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 取得描述
	 *
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * 设置事件处理集合
	 *
	 * @param eventHandlerCollection
	 *            事件处理集合
	 */
	public void setEventHandlerCollection(MetaEventHandlerCollection eventHandlerCollection) {
		this.eventHandlerCollection = eventHandlerCollection;
	}

	/**
	 * 取得事件处理集合
	 *
	 * @return 事件处理集合
	 */
	public MetaEventHandlerCollection getEventHandlerCollection() {
		return this.eventHandlerCollection;
	}

	/**
	 * 设置计算表达式集合
	 *
	 * @param calcExprCollection
	 *            计算表达式集合
	 */
	public void setCalcExprCollection(MetaUICalcExprCollection calcExprCollection) {
		this.calcExprCollection = calcExprCollection;
	}

	/**
	 * 取得计算表达式集合
	 *
	 * @return 计算表达式集合
	 */
	public MetaUICalcExprCollection getCalcExprCollection() {
		return this.calcExprCollection;
	}

	/**
	 * 获取是否弹窗关闭
	 *
	 * @return 标志
	 *
	 */
	public Boolean isConfirmClose() {
		return confirmClose;
	}

	/**
	 * 设置是否弹窗关闭
	 *
	 * @param confirmClose
	 *            标志
	 */
	public void setConfirmClose(Boolean confirmClose) {
		this.confirmClose = confirmClose;
	}

	public void setAnimationType(String animationType) {
		this.animationType = animationType;
	}

	public String getAnimationType() {
		return animationType;
	}

	public void setFullScreenType(int fullScreenType) {
		this.fullScreenType = fullScreenType;
	}

	public int getFullScreenType() {
		return fullScreenType;
	}

	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.disableKeyboard = disableKeyboard;
	}

	public Boolean isDisableKeyboard() {
		return disableKeyboard;
	}

	public void setAnimCollection(MetaAnimCollection animCollection) {
		this.animCollection = animCollection;
	}

	public MetaAnimCollection getAnimCollection() {
		return animCollection;
	}

	public void setServiceRightsCollection(MetaServiceRightsCollection serviceRightsCollection) {
		this.serviceRightsCollection = serviceRightsCollection;
	}

	public MetaServiceRightsCollection getServiceRightsCollection() {
		return serviceRightsCollection;
	}

	public StringHashMap<MetaListViewColumn> getListViewColumnMap() {
		return listViewColumnMap;
	}

	/**
	 * 设置配置版本号
	 *
	 * @param version
	 *            版本号
	 */
	public void setVersion(Integer version) {
		this.version = version;
	}

	/**
	 * 获取配置版本号
	 *
	 * @return 版本号
	 */
	public Integer getVersion() {
		return this.version;
	}

	/**
	 * 获取状态栏颜色
	 *
	 * @return 状态栏颜色
	 */
	public String getStatusBarColor() {
		return statusBarColor;
	}

	/**
	 * 设置状态栏颜色
	 *
	 * @param statusBarColor
	 *            状态栏颜色
	 */
	public void setStatusBarColor(String statusBarColor) {
		this.statusBarColor = statusBarColor;
	}

	/**
	 * 获取是否离线表单
	 *
	 * @return 是否离线表单
	 */
	public Boolean isOffLine() {
		return offLine;
	}

	/**
	 * 设置是否离线表单
	 *
	 * @param offLine
	 *            是否离线表单
	 */
	public void setOffLine(Boolean offLine) {
		this.offLine = offLine;
	}

	/**
	 * 获取水印
	 * @return 水印
	 */
	public MetaWatermark getWatermark() {
		return watermark;
	}

	/**
	 * 设置水印
	 * @param watermark 水印
	 */
	public void setWatermark(MetaWatermark watermark) {
		this.watermark = watermark;
	}

	/**
	 * 系统生成标志
	 *
	 * @param autoGen
	 *            标志
	 */
	public void setAutoGen(boolean autoGen) {
		this.autoGen = autoGen;
	}

	@Override
	public boolean isAutoGen() {
		return this.autoGen;
	}

	/**
	 * 多语言表单
	 *
	 * @param i18n
	 *            多语言
	 */
	public void setI18n(boolean i18n) {
		this.i18n = i18n;
	}

	public boolean isI18n() {
		return this.i18n;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list,
				new AbstractMetaObject[] { dataSource, optCollection, scriptCollection, queryCollection,
						uiCheckRuleCollection, metaBody, onLoad, onClose, onPostDataLoad, onPostShow, extendCollection,
						macroCollection, timerTaskCollection, formParaCollection, dataBindingCollection,
						formRelationCollection, eventHandlerCollection, navigation, calcExprCollection,
						keyHandlerCollection, rightsProxyCollection, animCollection, serviceRightsCollection,
						variant,watermark, typeGroup});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
													int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equals(MetaDataSource.TAG_NAME)) {
			dataSource = new MetaDataSource();
			resultMetaObject = dataSource;
		} else if (tagName.equals(MetaOperationCollection.TAG_NAME)) {
			optCollection = new MetaOperationCollection();
			resultMetaObject = this.optCollection;
		} else if (tagName.equals(MetaBody.TAG_NAME)) {
			metaBody = new MetaBody();
			resultMetaObject = this.metaBody;
		} else if (tagName.equals(MetaConstants.Event_OnLoad)) {
			onLoad = new MetaBaseScript(MetaConstants.Event_OnLoad);
			resultMetaObject = this.onLoad;
		} else if (tagName.equals(MetaConstants.Event_OnClose)) {
			onClose = new MetaBaseScript(MetaConstants.Event_OnClose);
			resultMetaObject = this.onClose;
		} else if (tagName.equals(MetaConstants.Event_OnPostShow)) {
			onPostShow = new MetaBaseScript(MetaConstants.Event_OnPostShow);
			resultMetaObject = this.onPostShow;
		} else if (tagName.equals(MetaConstants.Event_OnPostDataLoad)) {
			onPostDataLoad = new MetaBaseScript(MetaConstants.Event_OnPostDataLoad);
			resultMetaObject = this.onPostDataLoad;
		} else if (tagName.equals(MetaScriptCollection.TAG_NAME)) {
			scriptCollection = new MetaScriptCollection();
			resultMetaObject = this.scriptCollection;
		} else if (tagName.equals(MetaKeyHandlerCollection.TAG_NAME)) {
			keyHandlerCollection = new MetaKeyHandlerCollection();
			resultMetaObject = this.keyHandlerCollection;
		} else if (tagName.equals(MetaQueryCollection.TAG_NAME)) {
			queryCollection = new MetaQueryCollection();
			resultMetaObject = this.queryCollection;
		} else if (tagName.equals(MetaExtendCollection.TAG_NAME)) {
			this.extendCollection = new MetaExtendCollection();
			resultMetaObject = this.extendCollection;
		} else if (tagName.equals(MetaMacroCollection.TAG_NAME)) {
			this.macroCollection = new MetaMacroCollection();
			resultMetaObject = this.macroCollection;
		} else if (tagName.equals(MetaUICheckRuleCollection.TAG_NAME)) {
			this.uiCheckRuleCollection = new MetaUICheckRuleCollection();
			resultMetaObject = this.uiCheckRuleCollection;
		} else if (MetaTimerTaskCollection.TAG_NAME.equals(tagName)) {
			this.timerTaskCollection = new MetaTimerTaskCollection();
			resultMetaObject = this.timerTaskCollection;
		} else if (MetaFormParaCollection.TAG_NAME.equals(tagName)) {
			this.formParaCollection = new MetaFormParaCollection();
			resultMetaObject = this.formParaCollection;
		} else if (MetaDataBindingCollection.TAG_NAME.equals(tagName)) {
			this.dataBindingCollection = new MetaDataBindingCollection();
			resultMetaObject = this.dataBindingCollection;
		} else if (MetaFormRelationCollection.TAG_NAME.equals(tagName)) {
			this.formRelationCollection = new MetaFormRelationCollection();
			resultMetaObject = this.formRelationCollection;
		} else if (MetaNavigationBar.TAG_NAME.equals(tagName)) {
			this.navigation = new MetaNavigationBar();
			resultMetaObject = this.navigation;
		} else if (MetaEventHandlerCollection.TAG_NAME.equals(tagName)) {
			this.eventHandlerCollection = new MetaEventHandlerCollection();
			resultMetaObject = this.eventHandlerCollection;
		} else if (MetaRightsProxyCollection.TAG_NAME.equals(tagName)) {
			this.rightsProxyCollection = new MetaRightsProxyCollection();
			resultMetaObject = this.rightsProxyCollection;
		} else if (MetaUICalcExprCollection.TAG_NAME.equals(tagName)) {
			this.calcExprCollection = new MetaUICalcExprCollection();
			resultMetaObject = this.calcExprCollection;
		} else if (MetaAnimCollection.TAG_NAME.equals(tagName)) {
			this.animCollection = new MetaAnimCollection();
			resultMetaObject = this.animCollection;
		} else if (MetaServiceRightsCollection.TAG_NAME.equals(tagName)) {
			this.serviceRightsCollection = new MetaServiceRightsCollection();
			resultMetaObject = this.serviceRightsCollection;
		} else if (MetaVariant.TAG_NAME.equals(tagName)) {
			this.variant = new MetaVariant();
			resultMetaObject = this.variant;
		}else if (MetaWatermark.TAG_NAME.equalsIgnoreCase(tagName)) {
			watermark = new MetaWatermark();
			resultMetaObject = watermark;
		}else if (MetaCellTypeGroup.TAG_NAME.equalsIgnoreCase(tagName)){
			typeGroup = new MetaCellTypeGroup();
			resultMetaObject = typeGroup;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaForm newObject = new MetaForm();
		newObject.setKey(key);
		newObject.setAliasKey(aliasKey);
		newObject.setTemplateKey(templateKey);
		newObject.setCaption(caption);
		newObject.setCaptionEn(captionEn);
		newObject.setFormType(formType);
		newObject.setAuthenticate(authenticate);
		newObject.setInitFocus(initFocus);
		newObject.setDimValueProvider(dimValueProvider);
		newObject.setFormType(formType);
		newObject.setAbbrCaption(abbrCaption);
		newObject.setFormulaCaption(formulaCaption);
		newObject.setFormulaAbbrCaption(formulaAbbrCaption);
		newObject.setPlatform(platform);
		newObject.setDataSource(dataSource == null ? null : (MetaDataSource) dataSource.clone());
		newObject
				.setOperationCollection(optCollection == null ? null : (MetaOperationCollection) optCollection.clone());
		newObject.setMetaBody(metaBody == null ? null : (MetaBody) metaBody.clone());
		newObject.setProject(project);
		newObject.setInitState(initState);
		newObject.setViewKey(viewKey);
		newObject.setExtend(extend);
		newObject.setUseVariant(useVariant);
		newObject.setVariant(variant == null ? null : (MetaVariant) variant.clone());
		newObject.setLinkedFormKey(linkedFormKey);
		newObject.setOnLoad(onLoad == null ? null : (MetaBaseScript) onLoad.clone());
		newObject.setOnPostDataLoad(onPostDataLoad == null ? null : (MetaBaseScript) onPostDataLoad.clone());
		newObject.setOnPostShow(onPostShow == null ? null : (MetaBaseScript) onPostShow.clone());
		newObject
				.setScriptCollection(scriptCollection == null ? null : (MetaScriptCollection) scriptCollection.clone());
		newObject.setQueryCollection(queryCollection == null ? null : (MetaQueryCollection) queryCollection.clone());
		newObject
				.setExtendCollection(extendCollection == null ? null : (MetaExtendCollection) extendCollection.clone());
		newObject.setMacroCollection(macroCollection == null ? null : (MetaMacroCollection) macroCollection.clone());
		newObject.setUICheckRuleCollection(
				uiCheckRuleCollection == null ? null : (MetaUICheckRuleCollection) uiCheckRuleCollection.clone());
		newObject.setTimerTaskCollection(
				timerTaskCollection == null ? null : (MetaTimerTaskCollection) timerTaskCollection.clone());
		newObject.setFormParaCollection(
				formParaCollection == null ? null : (MetaFormParaCollection) formParaCollection.clone());
		newObject.setDataBindingCollection(
				dataBindingCollection == null ? null : (MetaDataBindingCollection) dataBindingCollection.clone());
		newObject.setFormRelationCollection(
				formRelationCollection == null ? null : (MetaFormRelationCollection) formRelationCollection.clone());
		newObject.setEventHandlerCollection(
				eventHandlerCollection == null ? null : (MetaEventHandlerCollection) eventHandlerCollection.clone());
		newObject.setCalcExprCollection(
				calcExprCollection == null ? null : (MetaUICalcExprCollection) calcExprCollection);
		newObject.setAnimCollection(animCollection == null ? null : (MetaAnimCollection) animCollection.clone());
		newObject.setAnimationType(animationType);
		newObject.setFullScreenType(fullScreenType);
		newObject.setDisableKeyboard(disableKeyboard);
		newObject.setHasNavigationBar(hasNavigationBar);
		newObject.setScreenOrientation(screenOrientation);
		newObject.setOnClose(onClose == null ? null : (MetaBaseScript) onClose.clone());
		newObject.setConfirmClose(confirmClose);
		newObject.setServiceRightsCollection(
				serviceRightsCollection == null ? null : (MetaServiceRightsCollection) serviceRightsCollection.clone());
		newObject.setVersion(version);
		newObject.setUserData(userData);
		newObject.setStatusBarColor(statusBarColor);
		newObject.setOffLine(offLine);
		newObject.setNavigation(navigation == null ? null : (MetaNavigationBar) navigation.clone());
		newObject.setRightsProxyCollection(
				rightsProxyCollection == null ? null : (MetaRightsProxyCollection) rightsProxyCollection.clone());
		newObject.setWatermark(watermark == null ? null : (MetaWatermark)watermark.clone());
		newObject.setTypeGroup(typeGroup == null ? null : (MetaCellTypeGroup)typeGroup.clone() );
		newObject.setI18n(i18n);
		newObject.setSourceForm(sourceForm);
		newObject.setDeliveryClass(deliveryClass);
		newObject.setTransFormKey(transFormKey);
		return newObject;
	}

	private void reset() {
		this.cellMap.clear();
		this.listViewColumnMap.clear();
		this.editViewColumnMap.clear();
		this.detailCompMap.clear();
		this.componentMap.clear();
		this.bindingMap.clear();
		this.localeMap.clear();
		this.subDetails.clear();
		this.tableRowMap.clear();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if (metaBody != null) {
			metaBody.doPostProcess(flag, callback);
		}
		if (scriptCollection != null) {
			scriptCollection.doPostProcess(flag, callback);
		}
		if (dataSource != null) {
			dataSource.doPostProcess(flag, callback);
		}
		if (queryCollection != null) {
			queryCollection.doPostProcess(flag, callback);
		}
		if (optCollection != null) {
			optCollection.doPostProcess(flag, callback);
		}
		if (formParaCollection != null) {
			formParaCollection.doPostProcess(flag, callback);
		}
		if (dataBindingCollection != null) {
			dataBindingCollection.doPostProcess(flag, callback);
		}
		if (uiCheckRuleCollection != null) {
			uiCheckRuleCollection.doPostProcess(flag, callback);
		}
		if (keyHandlerCollection != null) {
			keyHandlerCollection.doPostProcess(flag, callback);
		}
		if (rightsProxyCollection != null) {
			rightsProxyCollection.doPostProcess(flag, callback);
		}
		if (animCollection != null) {
			animCollection.doPostProcess(flag, callback);
		}
		if (serviceRightsCollection != null) {
			serviceRightsCollection.doPostProcess(flag, callback);
		}
		if (navigation != null) {
			navigation.doPostProcess(flag, callback);
		}
		if (watermark != null) {
			watermark.doPostProcess(flag, callback);
		}
		if(typeGroup != null){
			typeGroup.doPostProcess(flag, callback);
		}
		// 处理组件集
		if (metaBody != null) {
			buildAndCheckBody(metaBody);
			// 处理通配
			MetaGridWildcardProcess gwp = new MetaGridWildcardProcess(this);
			gwp.process();
			// 子明细处理
			MetaSubDetailProcess sdp = new MetaSubDetailProcess(this);
			sdp.process();
			// 伙伴组件处理
			MetaBuddyProcess bp = new MetaBuddyProcess(this);
			bp.process();
		}

		if(callback != null){
			try {
				callback.call(this);
			} catch (Throwable e) {
				throw new RuntimeException(e);
			}
		}
	}

	/**
	 * 用于检查表单的结构以及数据绑定是否正确,包括组件标识不能重复,绑定的表及列需要存在
	 *
	 * @return 通过返回"",不通过返回错误信息
	 * @throws MetaException
	 */
	public String checkValid() throws MetaException {
		if (metaBody == null) {
			return SimpleStringFormat.format(StringTable.getString(null, "", StringTable.BodyNotExists), this.key);
		}

		MetaDataObject dataObject = null;
		if (dataSource != null) {
			dataObject = dataSource.getDataObject();
		}

		Stack<MetaComponent> stack = new Stack<MetaComponent>();
		for (int i = 0, size = metaBody.size(); i < size; ++i) {
			stack.push(metaBody.get(i));
		}

		HashSet<String> setKey = new HashSet<String>();
		while (!stack.isEmpty()) {
			MetaComponent com = stack.pop();
			String tmpKey = com.getKey();

			if (setKey != null && !setKey.isEmpty()) {
				if (setKey.contains(tmpKey.toUpperCase())) {
					checkComponentKey(SimpleStringFormat.format(
							StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key, tmpKey,
							this.project.getKey() + File.separatorChar + this.resource));

				}
				setKey.add(tmpKey.toUpperCase());
			}

			switch (com.getControlType()) {
				case ControlType.GRID: {
					MetaGrid metaGrid = (MetaGrid) com;

					MetaGridCell metaCell = null;
					MetaDataBinding dataBinding = null;
					for (MetaGridRow metaRow : metaGrid.getRowCollection()) {
						for (int i = 0, size = metaRow.size(); i < size; i++) {
							metaCell = metaRow.get(i);
							tmpKey = metaCell.getKey();
							// 检查单元格的key是否重复
							if (tmpKey != null && !tmpKey.isEmpty()) {
								if (setKey.contains(tmpKey.toUpperCase())) {
									checkComponentKey( SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key,
											tmpKey, this.resource));
								}
								setKey.add(tmpKey.toUpperCase());
							}
							// 检查数据绑定是否正确
							dataBinding = metaCell.getDataBinding();
							if (dataBinding != null) {
								String columnKey = dataBinding.getColumnKey();
								if (columnKey != null && !columnKey.isEmpty()) {
									String tableKey = dataBinding.getTableKey();
									if (tableKey == null || tableKey.isEmpty()) {
										tableKey = metaRow.getTableKey();
									}
									if (dataObject == null || !dataObject.hasColumn(tableKey, columnKey)) {
										return SimpleStringFormat.format(
												StringTable.getString(null, "", StringTable.CellBindingFieldNotDefined),
												metaGrid.getKey(), metaCell.getKey(), tableKey, columnKey);
									}
								}
							}
						}
					}
				}
				break;
				case ControlType.LISTVIEW: {
					MetaListView listView = (MetaListView) com;
					MetaListViewColumnCollection metaColumnCollection = listView.getColumnCollection();
					if (metaColumnCollection != null) {
						Iterator<MetaListViewColumn> it = metaColumnCollection.iterator();
						MetaListViewColumn metaColumn = null;
						while (it.hasNext()) {
							metaColumn = it.next();
							tmpKey = metaColumn.getKey();
							if (tmpKey != null && !tmpKey.isEmpty()) {
								if (setKey.contains(tmpKey.toUpperCase())) {
									checkComponentKey( SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key,
											tmpKey, this.resource));
								}
								setKey.add(tmpKey.toUpperCase());
							}
							// 检查数据绑定是否正确
							String columnKey = metaColumn.getDataColumnKey();
							if (columnKey != null && !columnKey.isEmpty()) {
								String tableKey = metaColumn.getTableKey();
								if (tableKey == null || tableKey.isEmpty()) {
									tableKey = listView.getTableKey();
								}
								if (dataObject == null || !dataObject.hasColumn(tableKey, columnKey)) {
									return SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.ColumnBindingFieldNotDefined),
											listView.getKey(), metaColumn.getKey(), tableKey, columnKey);
								}
							}
						}
					}
				}
				break;
				case ControlType.TILEDLIST:
				case ControlType.GALLERY:
				case ControlType.ROTATOR:
				case ControlType.ROTATORLIST:
				case ControlType.WATERFALL:
				case ControlType.EDITVIEW: {
					MetaEditView EditView = (MetaEditView) com;
					MetaEditViewColumnCollection metaColumnCollection = EditView.getColumnCollection();
					if (metaColumnCollection != null) {
						Iterator<MetaEditViewColumn> it = metaColumnCollection.iterator();
						MetaEditViewColumn metaColumn = null;
						while (it.hasNext()) {
							metaColumn = it.next();
							tmpKey = metaColumn.getKey();
							if (tmpKey != null && !tmpKey.isEmpty()) {
								if (setKey.contains(tmpKey.toUpperCase())) {
									checkComponentKey( SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key,
											tmpKey, this.resource));
								}
								setKey.add(tmpKey.toUpperCase());
							}
							// 检查数据绑定是否正确
							String columnKey = metaColumn.getDataColumnKey();
							if (columnKey != null && !columnKey.isEmpty()) {
								String tableKey = metaColumn.getTableKey();
								if (tableKey == null || tableKey.isEmpty()) {
									tableKey = EditView.getTableKey();
								}
								if (dataObject == null || !dataObject.hasColumn(tableKey, columnKey)) {
									return SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.ColumnBindingFieldNotDefined),
											EditView.getKey(), metaColumn.getKey(), tableKey, columnKey);
								}
							}
						}
					}
				}
				break;
				case ControlType.COLLECTIONVIEW:{
					MetaCollectionView metaCollectionView = (MetaCollectionView)com;
					MetaCollectionViewRowCollection rowCollection = metaCollectionView.getRows();
					if(rowCollection != null){
						for(int i=0;i<rowCollection.size();i++){
							MetaCollectionViewRow metaCollectionViewRow =rowCollection.get(i);
							tmpKey = metaCollectionViewRow.getKey();
							if (setKey.contains(tmpKey.toUpperCase())) {
								checkComponentKey( SimpleStringFormat.format(
										StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key,
										tmpKey, this.resource));
							}
							setKey.add(tmpKey.toUpperCase());
							MetaComponent comp = metaCollectionViewRow.getRoot();
							stack.add(comp);
						}
					}
				}
				break;
				case ControlType.TABLEVIEW: {
					MetaTableView metaTableView = (MetaTableView) com;
					MetaTableRowCollection rowCollection = metaTableView.getRows();
					for (int i = 0; i < rowCollection.size(); i++) {
						MetaTableRow metaRow = rowCollection.get(i);
						tmpKey = metaRow.getKey();
						tableRowMap.put(tmpKey, metaRow);
						if (tmpKey != null && !tmpKey.isEmpty()) {
							if (setKey.contains(tmpKey.toUpperCase())) {
								checkComponentKey( SimpleStringFormat.format(
										StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key,
										tmpKey, this.resource));
							}
							setKey.add(tmpKey.toUpperCase());
						}
						boolean isMatch = false;
						if (metaRow.getRowType() == TableViewRowType.Fix) {
							isMatch = true;
						} else if (metaRow.getRowType() == TableViewRowType.Group) {
							if (i == (rowCollection.size() - 1)) {
								isMatch = true;
							} else {
								MetaTableRow nextRow = rowCollection.get(i + 1);
								if (nextRow.getRowType() == TableViewRowType.Fix) {
									isMatch = true;
								}
							}
						} else if (metaRow.getRowType() == TableViewRowType.GroupTail) {
							if (i == 0) {
								isMatch = true;
							} else {
								MetaTableRow preRow = rowCollection.get(i - 1);
								if (preRow.getRowType() == TableViewRowType.Fix) {
									isMatch = true;
								}
							}
						}
						if (isMatch) {
							MetaComponent comp = metaRow.getRoot();
							stack.add(comp);
						}
					}
				}
				break;
				case ControlType.REFRESHCONTROL:
					MetaRefreshControl refreshControl = (MetaRefreshControl) com;
					MetaComponent root = refreshControl.getRootComp();
					stack.add(root);
					break;
				case ControlType.SUBDETAIL:
					MetaSubDetail subDetail = (MetaSubDetail) com;
					String parentKey = subDetail.getBindingGridKey();
					if (parentKey == null || parentKey.isEmpty()) {
						return SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ParentGridNotFound),
								key, parentKey);
					}
					break;
				case ControlType.CONTAINER:
					MetaContainer metaContainer = (MetaContainer) com;
					MetaTabGroup metaTabGroup = metaContainer.getTabGroup();
					if (metaTabGroup != null) {
						stack.add(metaTabGroup);
					}
					break;
				case ControlType.TOOLBAR:
					MetaToolBar metaToolBar = (MetaToolBar) com;
					MetaToolBarItemCollection collection = metaToolBar.getItemCollection();
					if (collection != null) {
						for (MetaComponent child : collection) {
							stack.add(child);
						}
					}
					break;
				case ControlType.POPVIEW:
					MetaPopView popView = (MetaPopView) com;
					MetaComponent popViewRoot = popView.getRoot();
					stack.add(popViewRoot);
					break;
				case ControlType.POPBUTTON:
					MetaPopButton popButton = (MetaPopButton) com;
					MetaComponent popButtonRoot = popButton.getRoot();
					stack.add(popButtonRoot);
					break;
				case ControlType.SHRINKVIEW:
					MetaShrinkView shrinkView = (MetaShrinkView) com;
					stack.add(shrinkView.getRoot());
					MetaCollapseView collapseView = shrinkView.getCollapseView();
					if (collapseView != null) {
						stack.add(collapseView.getRoot());
					}
					MetaToolBarCollapse toolBarCollapse = shrinkView.getToolBarCollapse();
					if (toolBarCollapse != null) {
						stack.add(toolBarCollapse.getRoot());
					}
					MetaToolBarExpand toolBarExpand = shrinkView.getToolBarExpand();
					if (toolBarExpand != null) {
						stack.add(toolBarExpand.getRoot());
					}
					MetaOperationBar operationBar = shrinkView.getOperationBar();
					if (operationBar != null) {
						stack.add(operationBar.getRoot());
					}
					break;
				case ControlType.LISTLAYOUTVIEW:
					MetaListLayoutView listLayoutView = (MetaListLayoutView) com;
					MetaRowLayoutCollection layoutCollection = listLayoutView.getRowLayoutCollection();
					if (layoutCollection != null) {
						Iterator<MetaRowLayout> it = layoutCollection.iterator();
						while (it.hasNext()) {
							MetaRowLayout rowLayout = it.next();
							MetaPanel panel = rowLayout.getLayout();
							if (panel != null) {
								stack.add(panel);
							}
						}
					}
					break;
				default:
					MetaDataBinding dataBinding = com.getDataBinding();
					if (dataBinding != null) {
						String columnKey = dataBinding.getColumnKey();
						if (columnKey != null && !columnKey.isEmpty()) {
							String tableKey = dataBinding.getTableKey();
							if (dataObject == null || !dataObject.hasColumn(tableKey, columnKey)) {
								return SimpleStringFormat.format(
										StringTable.getString(null, "", StringTable.CompBindingFieldNotDefined),
										com.getKey(), tableKey, columnKey);
							}
						}
					}
			}

			// 加入子组件作为下一遍循环
			for (int i = 0, size = com.getComponentCount(); i < size; ++i) {
				MetaComponent child = com.getComponent(i);
				stack.add(child);
			}
		}
		return "";
	}

	/**
	 * 建立组件的关系结构以及检查配置的正确性
	 *
	 * @param metaBody
	 *            表体对象
	 * @throws MetaException
	 *             配置错误
	 */
	private void buildAndCheckBody(MetaBody metaBody) throws MetaException {

		// 重置,支持重复调用
		reset();

		MetaDataObject dataObject = null;
		if (dataSource != null) {
			dataObject = dataSource.getDataObject();
		}
		Stack<MetaComponent> stack = new Stack<MetaComponent>();
		for (int i = 0, size = metaBody.size(); i < size; ++i) {
			stack.push(metaBody.get(i));
		}

		if (navigation != null) {
			for (MetaNavigationBarItem item : navigation) {
				MetaComponent root = item.getRoot();
				if (root != null) {
					stack.push(root);
				}
			}
		}

		HashSet<String> setKey = new HashSet<String>();
		while (!stack.isEmpty()) {
			MetaComponent metaCom = stack.pop();
			if (metaCom == null)
				continue;
			String tmpKey = metaCom.getKey();
			// 已经存在标识
			if (setKey.contains(tmpKey.toUpperCase())) {
				checkComponentKey(  new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatComponentCellKey),
								this.key, tmpKey, this.project.getKey() + File.separatorChar + this.resource)).getMessage());
			}
			this.componentMap.put(metaCom.getKey(), metaCom);

			if (tmpKey != null && !tmpKey.isEmpty()) {
				setKey.add(tmpKey.toUpperCase());
			}
			if (this.formType != FormType.Template) {
				// 将表单配置中多语言读入集合
				doI18nProcess(metaCom);
				// 处理带PromptImage属性的组件
				addPromptImage(metaCom);
				switch (metaCom.getControlType()) {
					case ControlType.GRID: {
						MetaGrid metaGrid = (MetaGrid) metaCom;

						MetaGridCell metaCell = null;
						MetaDataBinding dataBinding = null;

						List<MetaGridColumn> leafColumns = metaGrid.getLeafColumns();

						for (MetaGridRow metaRow : metaGrid.getRowCollection()) {

							if( metaRow.size() != leafColumns.size() ) {
								throw new MetaException(MetaException.COLUMN_CELL_NOT_EQUAL,
										SimpleStringFormat.format(
												StringTable.getString(null, "", StringTable.ColumnCellNotEqual),
												this.key, metaGrid.getKey(), metaRow.getKey(), this.resource));
							}

							for (int i = 0, size = metaRow.size(); i < size; i++) {
								metaCell = metaRow.get(i);
								tmpKey = metaCell.getKey();
								// 检查单元格的key是否重复
								if (tmpKey != null && !tmpKey.isEmpty()) {
									if (setKey.contains(tmpKey.toUpperCase())) {
										checkComponentKey(  new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,
												SimpleStringFormat.format(
														StringTable.getString(null, "", StringTable.RepeatComponentCellKey),
														this.key, tmpKey, this.resource)).getMessage());
									}else {
										setKey.add(tmpKey.toUpperCase());
										cellMap.put(tmpKey, metaCell);
									}

								}
								// 检查数据绑定是否正确
								dataBinding = metaCell.getDataBinding();
								if (dataBinding != null) {
									String columnKey = dataBinding.getColumnKey();
									if (columnKey != null && !columnKey.isEmpty()) {
										String tableKey = dataBinding.getTableKey();
										if (tableKey == null || tableKey.isEmpty()) {
											tableKey = metaRow.getTableKey();
										}

										doDataBindingProcess(dataObject, metaCell, tableKey, columnKey);
									}
									// 预处理固定行单元格关键字
									if (metaRow.getRowType() == RowType.Fix) {
										String keywords = metaCell.getKeywords();
										if (keywords != null && !keywords.isEmpty()) {
											String tableKey = dataBinding.getTableKey();
											if (tableKey != null && !tableKey.isEmpty()) {
												doKeyWordsProcess(metaCell, dataObject.getTable(tableKey), keywords);
											}
										}
									}
								}
							}
							// 预处理明细行关键字
							if (metaRow.getRowType() == RowType.Detail) {
								String keywords = metaRow.getKeywords();
								if (keywords != null && !keywords.isEmpty()) {
									String tableKey = metaRow.getTableKey();
									if (tableKey != null && !tableKey.isEmpty()) {
										doKeyWordsProcess(metaRow, dataObject.getTable(tableKey), keywords);
									}
								}
							}
						}

						// 业务关键字
						String tableKey = metaGrid.getTableKey();
						if (tableKey != null && !tableKey.isEmpty()) {
							List<String> primaryKeys = new ArrayList<String>();
							MetaTable metaTable = dataObject.getMetaTable(tableKey);
							metaTable.forEach(metaColumn -> {
								if (metaColumn.getIsPrimary()) {
									primaryKeys.add(metaColumn.getKey());
								}
							});

							metaGrid.setPrimaryKeys(primaryKeys);
						}

						// 处理选择字段
						if (dataObject != null && metaGrid.hasSelectField()) {
							doSelectFieldProcess(dataObject, metaGrid);
						}

						// 额外操作标识检查
						MetaExtOptCollection extOpts = metaGrid.getExtOpts();
						if( extOpts != null ) {
							for( MetaExtOpt extOpt : extOpts ) {
								if( extOpt.getKey() == null || extOpt.getKey().isEmpty() ) {
									throw new MetaException(MetaException.EXTOPT_KEY_UNDEFINED,
											SimpleStringFormat.format(
													StringTable.getString(null, "", StringTable.ExtOptKeyUndefined),
													this.key, metaGrid.getKey(), this.resource));
								}
							}
						}
					}
					break;
					case ControlType.LISTVIEW: {
						MetaListView listView = (MetaListView) metaCom;
						MetaListViewColumnCollection metaColumnCollection = listView.getColumnCollection();
						if (metaColumnCollection != null) {
							Iterator<MetaListViewColumn> it = metaColumnCollection.iterator();
							MetaListViewColumn listColumn = null;
							while (it.hasNext()) {
								listColumn = it.next();
								tmpKey = listColumn.getKey();
								if (tmpKey != null && !tmpKey.isEmpty()) {
									if (setKey.contains(tmpKey.toUpperCase())) {
										checkComponentKey( new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,
												SimpleStringFormat.format(
														StringTable.getString(null, "", StringTable.RepeatComponentCellKey),
														this.key, tmpKey, this.resource)).getMessage());
									}
									setKey.add(tmpKey.toUpperCase());
									listViewColumnMap.put(tmpKey, listColumn);
								}
								// 检查数据绑定是否正确
								String columnKey = listColumn.getDataColumnKey();
								if (columnKey != null && !columnKey.isEmpty()) {
									String tableKey = listColumn.getTableKey();
									if (tableKey == null || tableKey.isEmpty()) {
										tableKey = listView.getTableKey();
									}

									doDataBindingProcess(dataObject, listColumn, tableKey, columnKey);
								}
								detailCompMap.put(tmpKey, listColumn);
								addPromptImage(listColumn);
							}
						}

						// 业务关键字
						String tableKey = listView.getTableKey();
						if (tableKey != null && !tableKey.isEmpty()) {
							List<String> primaryKeys = new ArrayList<String>();
							MetaTable metaTable = dataObject.getMetaTable(tableKey);
							metaTable.forEach(metaColumn -> {
								if (metaColumn.getIsPrimary()) {
									primaryKeys.add(metaColumn.getKey());
								}
							});
							listView.setPrimaryKeys(primaryKeys);
						}

						// 处理选择字段
						if (dataObject != null && listView.hasSelectField()) {
							doSelectFieldProcess(dataObject, metaCom);
						}
					}
					break;
					case ControlType.TILEDLIST:
					case ControlType.GALLERY:
					case ControlType.ROTATOR:
					case ControlType.ROTATORLIST:
					case ControlType.WATERFALL:
					case ControlType.EDITVIEW: {
						MetaEditView EditView = (MetaEditView) metaCom;
						MetaEditViewColumnCollection metaColumnCollection = EditView.getColumnCollection();
						if (metaColumnCollection != null) {
							Iterator<MetaEditViewColumn> it = metaColumnCollection.iterator();
							MetaEditViewColumn listColumn = null;
							while (it.hasNext()) {
								listColumn = it.next();
								tmpKey = listColumn.getKey();
								if (tmpKey != null && !tmpKey.isEmpty()) {
									if (setKey.contains(tmpKey.toUpperCase())) {
										checkComponentKey(  new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,
												SimpleStringFormat.format(
														StringTable.getString(null, "", StringTable.RepeatComponentCellKey),
														this.key, tmpKey, this.resource)).getMessage());
									}
									setKey.add(tmpKey.toUpperCase());
									editViewColumnMap.put(tmpKey, listColumn);
								}
								// 检查数据绑定是否正确
								String columnKey = listColumn.getDataColumnKey();
								if (columnKey != null && !columnKey.isEmpty()) {
									String tableKey = listColumn.getTableKey();
									if (tableKey == null || tableKey.isEmpty()) {
										tableKey = EditView.getTableKey();
									}

									doDataBindingProcess(dataObject, listColumn, tableKey, columnKey);
								}
								detailCompMap.put(tmpKey, listColumn);
								addPromptImage(listColumn);
							}
						}

						// 业务关键字
						String tableKey = EditView.getTableKey();
						if (tableKey != null && !tableKey.isEmpty()) {
							List<String> primaryKeys = new ArrayList<String>();
							MetaTable metaTable = dataObject.getMetaTable(tableKey);
							metaTable.forEach(metaColumn -> {
								if (metaColumn.getIsPrimary()) {
									primaryKeys.add(metaColumn.getKey());
								}
							});
							EditView.setPrimaryKeys(primaryKeys);
						}

						// 处理选择字段
						if (dataObject != null && EditView.hasSelectField()) {
							doSelectFieldProcess(dataObject, metaCom);
						}
					}
					break;
					case ControlType.COLLECTIONVIEW: {
						MetaCollectionView metaCollectionView = (MetaCollectionView) metaCom;
						MetaCollectionViewRowCollection rowCollection = metaCollectionView.getRows();
						if (rowCollection != null) {
							for (int i = 0; i < rowCollection.size(); i++) {
								MetaCollectionViewRow metaCollectionViewRow = rowCollection.get(i);
								tmpKey = metaCollectionViewRow.getKey();
								if (setKey.contains(tmpKey.toUpperCase())) {
									checkComponentKey(  new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,
											SimpleStringFormat.format(
													StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key,
													tmpKey, this.resource)).getMessage());
								}
								setKey.add(tmpKey.toUpperCase());
								MetaComponent comp = metaCollectionViewRow.getRoot();
								stack.add(comp);
							}
						}
					}
					break;
					case ControlType.TABLEVIEW: {
						MetaTableView metaTableView = (MetaTableView) metaCom;
						MetaTableRowCollection rowCollection = metaTableView.getRows();
						for (int i = 0; i < rowCollection.size(); i++) {
							MetaTableRow metaRow = rowCollection.get(i);
							tmpKey = metaRow.getKey();
							tableRowMap.put(tmpKey,metaRow);
							if (setKey.contains(tmpKey.toUpperCase())) {
								checkComponentKey(  new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,
										SimpleStringFormat.format(
												StringTable.getString(null, "", StringTable.RepeatComponentCellKey), this.key,
												tmpKey, this.resource)).getMessage());
							}
							setKey.add(tmpKey.toUpperCase());
							boolean isMatch = false;
							if (metaRow.getRowType() == TableViewRowType.Fix) {
								isMatch = true;
							} else if (metaRow.getRowType() == TableViewRowType.Group) {
								if (i == (rowCollection.size() - 1)) {
									isMatch = true;
								} else {
									MetaTableRow nextRow = rowCollection.get(i + 1);
									if (nextRow.getRowType() == TableViewRowType.Fix) {
										isMatch = true;
									}
								}
							} else if (metaRow.getRowType() == TableViewRowType.GroupTail) {
								if (i == 0) {
									isMatch = true;
								} else {
									MetaTableRow preRow = rowCollection.get(i - 1);
									if (preRow.getRowType() == TableViewRowType.Fix) {
										isMatch = true;
									}
								}
							} else if (metaRow.getRowType() == TableViewRowType.Detail) {
								detailCompMap.put(metaRow.getRoot().getKey(), metaRow.getRoot());
							}
							if (isMatch) {
								MetaComponent comp = metaRow.getRoot();
								stack.add(comp);
							} else {
								addRootDetailComp(detailCompMap, metaRow.getRoot(), setKey, metaRow.getTableKey());
							}
						}
					}
					break;
					case ControlType.REFRESHCONTROL:
						MetaRefreshControl refreshControl = (MetaRefreshControl) metaCom;
						MetaComponent root = refreshControl.getRootComp();
						stack.add(root);
						break;
					case ControlType.COMBOVIEW:
						MetaComboView comRoot = (MetaComboView) metaCom;
						MetaComponent comRootView = comRoot.getRoot();
						stack.add(comRootView);
						break;
					case ControlType.CONTAINER:
						MetaContainer metaContainer = (MetaContainer) metaCom;
						MetaTabGroup metaTabGroup = metaContainer.getTabGroup();
						if (metaTabGroup != null) {
							stack.add(metaTabGroup);
						}
						break;
					case ControlType.TOOLBAR:
						MetaToolBar metaToolBar = (MetaToolBar) metaCom;
						MetaToolBarItemCollection collection = metaToolBar.getItemCollection();
						if (collection != null) {
							for (MetaComponent child : collection) {
								stack.add(child);
							}
						}
						break;
					case ControlType.COLLAPSEPANEL:
						MetaCollapsePanel metaCollapse = (MetaCollapsePanel) metaCom;
						MetaCollapseCollection collapseCollection = metaCollapse.getItems();
						if (collapseCollection != null) {
							Iterator<MetaCollapseItem> it = collapseCollection.iterator();
							while (it.hasNext()) {
								MetaCollapseItem metaItem = it.next();
								stack.addAll(metaItem.getCompList());
							}
						}
						break;
					case ControlType.POPVIEW:
						MetaPopView popView = (MetaPopView) metaCom;
						MetaComponent popViewRoot = popView.getRoot();
						stack.add(popViewRoot);
						break;
					case ControlType.SUBDETAIL:
						if (this.subDetails == null) {
							this.subDetails = new ArrayList<MetaComponent>();
						}
						subDetails.add(metaCom);
						break;
					case ControlType.POPBUTTON:
						MetaPopButton popButton = (MetaPopButton) metaCom;
						MetaComponent popButtonRoot = popButton.getRoot();
						stack.add(popButtonRoot);
						break;
					case ControlType.SHRINKVIEW:
						MetaShrinkView shrinkView = (MetaShrinkView) metaCom;
						stack.add(shrinkView.getRoot());
						MetaCollapseView collapseView = shrinkView.getCollapseView();
						if (collapseView != null) {
							stack.add(collapseView.getRoot());
						}
						MetaToolBarCollapse toolBarCollapse = shrinkView.getToolBarCollapse();
						if (toolBarCollapse != null) {
							stack.add(toolBarCollapse.getRoot());
						}
						MetaToolBarExpand toolBarExpand = shrinkView.getToolBarExpand();
						if (toolBarExpand != null) {
							stack.add(toolBarExpand.getRoot());
						}
						MetaOperationBar operationBar = shrinkView.getOperationBar();
						if (operationBar != null) {
							stack.add(operationBar.getRoot());
						}
						break;
					case ControlType.LISTLAYOUTVIEW:
						MetaListLayoutView listLayoutView = (MetaListLayoutView) metaCom;
						MetaRowLayoutCollection metaRowLayoutCollection = listLayoutView.getRowLayoutCollection();
						if (metaRowLayoutCollection != null) {
							Iterator<MetaRowLayout> it = metaRowLayoutCollection.iterator();
							MetaRowLayout rowLayout = null;
							while (it.hasNext()) {
								rowLayout = it.next();
								MetaPanel panel = rowLayout.getLayout();
								if (panel != null) {
									stack.add(panel);
								}
							}
						}
						break;
					default:
						MetaDataBinding dataBinding = metaCom.getDataBinding();
						if (dataBinding != null) {
							String columnKey = dataBinding.getColumnKey();
							if (columnKey != null && !columnKey.isEmpty()) {
								String tableKey = dataBinding.getTableKey();

								doDataBindingProcess(dataObject, metaCom, tableKey, columnKey);
							}
						}
				}
			}
			// 加入子组件作为下一遍循环
			for (int i = 0, size = metaCom.getComponentCount(); i < size; ++i) {
				stack.add(metaCom.getComponent(i));
			}
		}
		if (this.formType != FormType.Template) {
			// 处理子明细绑定以及相关属性
			Iterator<MetaComponent> it = subDetails.iterator();
			MetaSubDetail metaSub = null;
			while( it.hasNext() ) {
				metaSub = (MetaSubDetail) it.next();
				String parentKey = metaSub.getBindingGridKey();
				if( parentKey == null || parentKey.isEmpty() ) {
					throw new MetaException(MetaException.PARENT_GRID_NOT_FOUND,
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ParentGridNotFound),key,parentKey));
				}
				MetaComponent metaComponent = componentMap.get(parentKey);
				if (metaComponent != null && metaComponent instanceof MetaGrid) {
					MetaGrid metaGrid = (MetaGrid) metaComponent;
					processSubDetail(metaSub.getRoot(), metaGrid);
				}
			}
		}

	}

	private void processSubDetail(MetaComponent rootCom,MetaGrid metaGrid) {
		if( rootCom.isPanel() ) {
			MetaPanel metaPanel = (MetaPanel)rootCom;
			for(MetaComponent meta : metaPanel.getComponentArray()){
				if(meta.getControlType() == ControlType.SUBDETAIL)
					continue;
				if( meta.isPanel() ){
					processSubDetail(meta, metaGrid);
				} else {
					impl_processCom(meta, metaGrid);
				}
			}
			rootCom.setParentGridKey(metaGrid.getKey());
		} else {
			impl_processCom(rootCom, metaGrid);
		}
	}

	private void impl_processCom(MetaComponent meta,MetaGrid metaGrid) {
		String gridKey = metaGrid.getKey();
		if( meta.getControlType() != ControlType.GRID ) {
			if( meta.hasDataBinding() && meta.getTableKey().equals(metaGrid.getTableKey()) ) {
				meta.setParentGridKey(gridKey);
			}
			String cellKey = meta.getBindingCellKey();
			MetaGridCell bindCell = null;
			if( cellKey != null && !cellKey.isEmpty() ) {
				meta.setParentGridKey(gridKey);
				bindCell = cellMap.get(cellKey);
			}
			if( meta.isSubDetail() ) {
				impl_processAttrs(meta, metaGrid, bindCell);
			}
		} else {
			meta.setParentGridKey(gridKey);
		}
	}

	private static void impl_processAttrs(MetaComponent meta,MetaGrid metaGrid,MetaGridCell bindCell) {
		MetaBaseScript onclick = null;
		switch (meta.getControlType()) {
			case ControlType.BUTTON:
				MetaButton metaButton = (MetaButton)meta;
				onclick = metaButton.getOnClick();
				if( (onclick == null || onclick.isEmpty()) && bindCell != null && bindCell.getCellType() == ControlType.BUTTON ) {
					MetaBaseScript script = ((MetaButtonProperties)bindCell.getProperties()).getOnClick();
					if( script != null ) {
						metaButton.setOnClick((MetaBaseScript) script.clone());
					}
				}
				break;
			case ControlType.HYPERLINK:
				MetaHyperLink hyperLink = (MetaHyperLink)meta;
				onclick = hyperLink.getOnClick();
				if( (onclick == null || onclick.isEmpty()) && bindCell != null && bindCell.getCellType() == ControlType.HYPERLINK ) {
					MetaBaseScript script = ((MetaHyperLinkProperties)bindCell.getProperties()).getOnClick();
					if( script != null ) {
						hyperLink.setOnClick((MetaBaseScript) script.clone());
					}
				}
				break;
			case ControlType.DICT:
				MetaDict metaDict = (MetaDict)meta;
				MetaItemFilterCollection filters = metaDict.getFilters();
				if( (filters == null || filters.size() == 0) && bindCell != null && bindCell.getCellType() == ControlType.DICT ) {
					MetaItemFilterCollection itemFilters = ((MetaDictProperties)bindCell.getProperties()).getFilters();
					if( itemFilters != null ) {
						((MetaDictProperties)metaDict.getProperties()).setFilters((MetaItemFilterCollection) itemFilters.clone());
					}
				}
				break;
			default:
				break;
		}
	}

	private void addPromptImage(MetaComponent metaComp) {
		switch (metaComp.getControlType()) {
			case ControlType.IMAGE:
				MetaImage metaImage = (MetaImage) metaComp;
				if(StringUtils.isNotEmpty(metaImage.getPromptImage()))
					this.promptImages.add(metaImage.getPromptImage());
				break;
			case ControlType.IMAGELIST:
				MetaImageList metaImageList = (MetaImageList) metaComp;
				if(StringUtils.isNotEmpty(metaImageList.getPromptImage()))
					this.promptImages.add(metaImageList.getPromptImage());
				break;
			case ControlType.TABLEVIEW:
				MetaTableView metaTableView = (MetaTableView) metaComp;
				for (MetaTableRow metaTableRow : metaTableView.getRows().getList()) {
					String promptImage = metaTableRow.getPromptImage();
					if(promptImage!= null && !promptImage.isEmpty()) {
						this.promptImages.add(metaTableRow.getPromptImage());
					}
				}
				break;
			case ControlType.COLLECTIONVIEW:
				break;
			case ControlType.LISTLAYOUTVIEW:
			case ControlType.LISTVIEW:
				MetaListView metaListView = (MetaListView) metaComp;
				if(StringUtils.isNotEmpty(metaListView.getPromptImage()))
					promptImages.add(metaListView.getPromptImage());
				break;
			case ControlType.ROTATOR:
			case ControlType.ROTATORLIST:
			case ControlType.WATERFALL:
			case ControlType.GALLERY:
			case ControlType.TILEDLIST:
			case ControlType.EDITVIEW:
				MetaEditView metaEditView = (MetaEditView) metaComp;
				if(StringUtils.isNotEmpty(metaEditView.getPromptImage()))
					promptImages.add(metaEditView.getPromptImage());
				break;
			case ControlType.OTHER:
				if(metaComp instanceof MetaListViewColumn){
					if(((MetaListViewColumn)metaComp).getColumnType() == ControlType.IMAGE ){
						MetaImageProperties imageProperties = (MetaImageProperties) metaComp.getProperties();
						if(StringUtils.isNotEmpty(imageProperties.getPromptImage())){
							this.promptImages.add(imageProperties.getPromptImage());
						}
					}else if(((MetaListViewColumn)metaComp).getColumnType() == ControlType.IMAGELIST ){
						MetaImageListProperties imageProperties = (MetaImageListProperties) metaComp.getProperties();
						if(StringUtils.isNotEmpty(imageProperties.getPromptImage())){
							this.promptImages.add(imageProperties.getPromptImage());
						}
					}
				}else if(metaComp instanceof MetaEditViewColumn){
					if(((MetaEditViewColumn)metaComp).getColumnType() == ControlType.IMAGE ){
						MetaImageProperties imageProperties = (MetaImageProperties) metaComp.getProperties();
						if(StringUtils.isNotEmpty(imageProperties.getPromptImage())){
							this.promptImages.add(imageProperties.getPromptImage());
						}
					}else if(((MetaEditViewColumn)metaComp).getColumnType() == ControlType.IMAGELIST ){
						MetaImageListProperties imageProperties = (MetaImageListProperties) metaComp.getProperties();
						if(StringUtils.isNotEmpty(imageProperties.getPromptImage())){
							this.promptImages.add(imageProperties.getPromptImage());
						}
					}
				}
				break;
			default:
				break;
		}
	}

	private void doI18nProcess(MetaComponent metaCom) {
		MetaI18n i18n = metaCom.getI18n();
		if (i18n != null) {
			Iterator<MetaI18nItem> it = i18n.iterator();
			MetaI18nItem item = null;
			while (it.hasNext()) {
				item = it.next();
				HashMap<String, String> map = this.localeMap.get(item.getKey());
				if (map == null) {
					map = new HashMap<String, String>();
					this.localeMap.put(item.getKey(), map);
				}
				map.put(metaCom.getKey(), item.getValue());
			}
		}
	}

	private void doDataBindingProcess(MetaDataObject dataObject, IPropertiesElement ele, String tableKey,
									  String columnKey) {
		MetaTable metaTable = null;
		if (dataObject != null) {
			metaTable = dataObject.getMetaTable(tableKey);
		}

		MetaColumn metaColumn = null;
		if (metaTable != null) {
			metaColumn = metaTable.get(columnKey);
		}

		if (metaColumn == null) {
			throw new MetaException(MetaException.BINDING_FIELD_NOT_DEFINED,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.CompBindingFieldNotDefined),
							this.key, ele.getKey(), tableKey, columnKey));
		}

		ele.setAccessControl(metaColumn.isAccessControl());
		ele.setDsDefaultValue(metaColumn.getDefaultValue());

		bindingMap.buildBinding(tableKey, columnKey, ele);

		// 对于数据列的特殊处理(这种改动配置的方式是比较危险的,要放在统一位置处理)
		if (metaColumn.getDataType() == DataType.INT || metaColumn.getDataType() == DataType.LONG) {
			switch (ele.getElementType()) {
				case ControlType.COMBOBOX:
					((MetaComboBoxProperties) ele.getProperties()).setIntegerValue(true);
					break;
				case ControlType.NUMBEREDITOR:
					((MetaNumberEditorProperties) ele.getProperties()).setScale(0);
					break;
				default:
					break;
			}
		}

		MetaDataElement dataElement = metaColumn.getDataElement();
		if(dataElement != null) {
			MetaAnnotationUtil.mergeProperty(ele, dataElement);
		}
	}

	/**
	 * "A=10000;B=10001"
	 */
	private static void doKeyWordsProcess(IDimValueAware meta, MetaTable metaTable, String keywords) {
		String[] values = keywords.split("[;]");
		String str = null;
		String[] arr = null;
		int dataType = -1;
		Object value = null;
		MultiDimValue dimValue = null;
		for (int i = 0, length = values.length; i < length; i++) {
			str = values[i].trim();
			if (str != null && !str.isEmpty()) {
				arr = str.split("[=]");
				dataType = metaTable.get(arr[0]).getDataType();
				value = TypeConvertor.toDataType(dataType, arr[1]);
				if (dimValue == null) {
					dimValue = new MultiDimValue();
				}
				dimValue.addValue(new MultiDimNode(arr[0], dataType, value));
			}
		}
		meta.setDimValue(dimValue);
	}

	/**
	 * 如果表格或者ListView有选择字段,那么在配置中增加一列不持久化的列
	 */
	private void doSelectFieldProcess(MetaDataObject dataObject, MetaComponent meta) {
		String tableKey = meta.getTableKey();
		if (tableKey == null || tableKey.isEmpty())
			return;
		MetaTable metaTable = dataObject.getMetaTable(tableKey);
		MetaColumn column = new MetaColumn();
		column.setKey(SystemField.SELECT_FIELD_KEY);
		column.setDataType(DataType.INT);
		column.setPersist(false);
		column.setIgnoreQuery(true);
		column.setAutoGen(true);
		metaTable.add(column);
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaForm();
	}

	/**
	 * 根据组件的标识取得组件定义
	 *
	 * @param key
	 *            组件标识
	 * @return 如果存在key指定的组件则返回组件定义，否则返回null
	 */
	public MetaComponent componentByKey(String key) {
		return this.componentMap == null ? null : this.componentMap.get(key);
	}

	/**
	 * 根据单元格的key取得单元格定义
	 *
	 * @param cellKey
	 *            单元格标识
	 * @return 对应标识的单元格定义
	 */
	public MetaGridCell metaGridCellByKey(String cellKey) {
		return this.cellMap == null ? null : this.cellMap.get(cellKey);
	}

	/***
	 * 根据列标识获取列表中的列定义
	 *
	 * @param columnKey
	 *            列标识
	 * @return 列定义
	 */
	public MetaListViewColumn metaListViewColumnByKey(String columnKey) {
		return this.listViewColumnMap == null ? null : this.listViewColumnMap.get(columnKey);
	}

	/***
	 * 根据列标识获取列表中的列定义
	 *
	 * @param columnKey
	 *            列标识
	 * @return 列定义
	 */
	public MetaEditViewColumn metaEditViewColumnByKey(String columnKey) {
		return this.editViewColumnMap == null ? null : this.editViewColumnMap.get(columnKey);
	}

	/**
	 * 根据组件的标识获取TableView明细行中的对应的组件定义
	 *
	 * @param compKey
	 *            组件标识
	 * @return 组件定义
	 */
	public MetaComponent metaDetailComponentByKey(String compKey) {
		return this.detailCompMap == null ? null : this.detailCompMap.get(compKey);
	}

	/**
	 * 根据组件的标识获取TableView行
	 *
	 * @param tableRowKey
	 *            组件标识
	 * @return 组件定义
	 */
	public MetaTableRow metaTableRowByKey(String tableRowKey) {
		return this.tableRowMap == null ? null : this.tableRowMap.get(tableRowKey);
	}

	/**
	 * 根据标识获取模板定义
	 *
	 * @param key
	 * @return
	 */
	public MetaEmbed embedByKey(String key) {
		return this.embedMap.get(key);
	}

	/**
	 * 获取所有模板
	 *
	 * @return
	 */
	public List<MetaEmbed> getEmbeds() {
		return new ArrayList<MetaEmbed>(this.embedMap.values());
	}

	/**
	 * 添加一个模板配置
	 *
	 * @param embed
	 *            模板配置
	 */
	public void addEmbed(MetaEmbed embed) {
		this.embedMap.put(embed.getKey(), embed);
	}

	/**
	 * 获取所有的子明细
	 *
	 * @return 所有的子明细
	 */
	public List<MetaComponent> getSubDetails() {
		return subDetails;
	}

	/**
	 * 取得所有component组件
	 *
	 * @return 所有组件的列表
	 */
	public List<MetaComponent> getAllComponents() {
		return new ArrayList<MetaComponent>(this.componentMap.values());
	}

	public List<MetaComponent> getAllDetailComponents(){
		return new ArrayList<MetaComponent>(this.detailCompMap.values());
	}

	/**
	 * 获取界面上所有控件以及单元格标识
	 *
	 * @return 所有控件及单元格标识的列表
	 */
	public List<String> getAllKeys() {
		List<String> keys = new ArrayList<String>();
		keys.addAll(this.componentMap.keySet());
		keys.addAll(this.cellMap.keySet());
		keys.addAll(this.detailCompMap.keySet());
		return keys;
	}

	/**
	 * 取得所有表格的所有单元格
	 *
	 * @return 所有表格中的单元格定义集合
	 */
	public List<MetaGridCell> getAllGridCells() {
		return new ArrayList<MetaGridCell>(this.cellMap.values());
	}

	/**
	 * 设置关联的序事簿标识
	 *
	 * @param viewKey
	 *            关联序事簿标识
	 */
	public void setViewKey(String viewKey) {
		this.viewKey = viewKey;
	}

	/**
	 * 获取序事簿标识
	 *
	 * @return 序事簿标识
	 */
	public String getViewKey() {
		return this.viewKey;
	}

	/**
	 * 获取继承表单的标识
	 *
	 * @return 继承表单的标识
	 */
	public String getExtend() {
		return extend;
	}

	/**
	 * 设置继承表单的标识
	 *
	 * @param extend
	 *            继承表单的标识
	 */
	public void setExtend(String extend) {
		this.extend = extend;
	}

	/**
	 * 设置关联单据标识
	 *
	 * @param linkedFormKey
	 *            关联表单
	 */
	public void setLinkedFormKey(String linkedFormKey) {
		this.linkedFormKey = linkedFormKey;
	}

	/**
	 * 获取关联单据标识
	 *
	 * @return 关联表单标识
	 */
	public String getLinkedFormKey() {
		return this.linkedFormKey;
	}

	/**
	 * 设置是否持有导航条
	 *
	 * @param hasNavigationBar
	 *            标志
	 */
	public void setHasNavigationBar(String hasNavigationBar) {
		this.hasNavigationBar = hasNavigationBar;
	}

	/**
	 * 是否持有导航条
	 *
	 * @return 标志
	 */
	public String isHasNavigationBar() {
		return hasNavigationBar;
	}

	/**
	 * 获取是否合并至源单
	 * @return
	 */
	public Boolean getMergeToSource() {
		return mergeToSource;
	}

	/**
	 * 设置是否合并至源单
	 * @param mergeToSource
	 */
	public void setMergeToSource(Boolean mergeToSource) {
		this.mergeToSource = mergeToSource;
	}

	/**
	 * 获取当前表单的动态单元格配置
	 * @return
	 */
	public MetaCellTypeDef getTypeDef(String typeDefKey) {
		return typeGroup == null ? null : typeGroup.get(typeDefKey);
	}

	/**
	 * 设置当前表单的动态单元格配置
	 * @param typeGroup
	 */
	public void setTypeGroup(MetaCellTypeGroup typeGroup) {
		this.typeGroup = typeGroup;
	}

	/**
	 * 获取当前表单的动态单元格配置
	 * @return
	 */
	public MetaCellTypeGroup getTypeGroup() {
		return typeGroup;
	}

	/**
	 * 动态获取当前界面所有控件集合，getAllComponent不一定是即时的,此方法只获取头表和grid字段信息
	 *
	 * @return 界面上所有控件的标识与定义的字典
	 */
	public HashMap<String, AbstractMetaObject> getAllUIComponents() {
		HashMap<String, AbstractMetaObject> componentMap = new HashMap<String, AbstractMetaObject>();
		Stack<MetaComponent> stack = new Stack<MetaComponent>();
		for (int i = 0, size = metaBody.size(); i < size; ++i) {
			stack.push(metaBody.get(i));
		}

		while (!stack.isEmpty()) {
			MetaComponent pop = stack.pop();
			componentMap.put(pop.getKey(), pop);

			if (pop.getControlType() == ControlType.GRID) {
				MetaGrid metaGrid = (MetaGrid) pop;
				if (metaGrid.getRowCollection() == null){
					metaGrid.setRowCollection(new MetaGridRowCollection());
				}
				for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
					int rowType = metaGridRow.getRowType();
					if (rowType == RowType.Detail || rowType == RowType.Fix) {
						for (int i = 0; i < metaGridRow.size(); i++) {
							MetaGridCell metaGridCell = metaGridRow.get(i);
							String tmpKey = metaGridCell.getKey();
							componentMap.put(tmpKey, metaGridCell);
						}
					}
				}
			}
			if(pop.getControlType() == ControlType.TABLEVIEW){
				MetaTableView tableView = (MetaTableView)pop;
				for (MetaTableRow metaTableRow : tableView.getRows()) {
					MetaComponent metaRoot = metaTableRow.getRoot();
					if(metaRoot != null){
						stack.add(metaRoot);
					}
				}
			}
			if(pop.getControlType() == ControlType.COLLECTIONVIEW){
				MetaCollectionView collectionView = (MetaCollectionView)pop;
				for (MetaCollectionViewRow metaCollectionViewRow : collectionView.getRows().getList()) {
					MetaComponent metaRoot = metaCollectionViewRow.getRoot();
					if(metaRoot != null){
						stack.add(metaRoot);
					}
				}
			}

			if(pop.getControlType() == ControlType.COLLAPSEPANEL){
				MetaCollapsePanel metaCollapsePanel = (MetaCollapsePanel)pop;
				MetaCollapseCollection items = metaCollapsePanel.getItems();
				MetaCollapseItem item = null;
				for (int i = 0; i < items.size(); i++) {
					item = items.get(i);
					ArrayList<MetaComponent> comps = item.getCompList();
					for (int j = 0; j < comps.size(); j++) {
						stack.add(comps.get(j));
					}
				}
			}

			if(pop.getControlType() == ControlType.REFRESHCONTROL){
				MetaRefreshControl metaRefreshControl = (MetaRefreshControl)pop;
				stack.add(metaRefreshControl.getRootComp());
			}

			if(pop.getControlType() == ControlType.POPVIEW){
				MetaPopView metaPopView = (MetaPopView) pop;
				stack.add(metaPopView.getRoot());
			}

			// 加入子组件作为下一遍循环
			for (int i = 0, size = pop.getComponentCount(); i < size; ++i) {
				MetaComponent child = pop.getComponent(i);
				stack.add(child);
			}
		}

		return componentMap;
	}

	/**
	 * 获取表单配置的一种语言控件的caption
	 *
	 * @param lang
	 *            语种标志
	 * @param key
	 *            组标标识
	 * @return 词条
	 */
	public String getUILangCaption(String lang, String key) {
		String s = null;
		if (localeMap.containsKey(lang)) {
			s = localeMap.get(lang).get(key);
		}
		return s;
	}

	/**
	 * 设置字符串表
	 *
	 * @param strings
	 *            字符串表
	 */
	public void setStrings(MetaStringTable strings) {
		this.strings = strings;
	}

	/**
	 * 取得字符串表
	 *
	 * @return 字符串表
	 */
	public MetaStringTable getStrings() {
		return this.strings;
	}

	/**
	 * 设置用户自定义数据
	 *
	 * @param userData
	 *            用户自定义数据
	 */
	public void setUserData(String userData) {
		this.userData = userData;
	}

	/**
	 * 取得用户自定义数据
	 *
	 * @return 用户自定义数据
	 */
	public String getUserData() {
		return this.userData;
	}

	/**
	 * 取得源单标识
	 *
	 * @return 源单标识
	 */
	public String getSourceForm() {
		return sourceForm;
	}

	/**
	 * 设置源单标识
	 *
	 * @param sourceForm  源单标识
	 */
	public void setSourceForm(String sourceForm) {
		this.sourceForm = sourceForm;
	}

	/**
	 * 取得交付类
	 *
	 * @return 交付类
	 */
	public String getDeliveryClass() {
		return deliveryClass;
	}

	/**
	 * 取得交付类
	 *
	 * @param deliveryClass  交付类
	 */
	public void setDeliveryClass(String deliveryClass) {
		this.deliveryClass = deliveryClass;
	}
	public String getTransFormKey() {
		return transFormKey;
	}

	public void setTransFormKey(String transFormKey) {
		this.transFormKey = transFormKey;
	}

	/**
	 * 根据组件绑定的表名获取对应的组件
	 *
	 * @param tableKey
	 *            表名
	 * @return 表名对应的组件,找不到返回null
	 */
	public MetaComponent findComponentByTable(String tableKey) {
		Iterator<Entry<String, MetaComponent>> it = this.componentMap.entrySet().iterator();
		Entry<String, MetaComponent> entry = null;
		while (it.hasNext()) {
			entry = it.next();
			MetaComponent metaComponent = entry.getValue();
			switch (metaComponent.getControlType()) {
				case ControlType.GRID:
					MetaGrid metaGrid = (MetaGrid) metaComponent;
					if (metaGrid.getTableKey().equals(tableKey))
						return metaGrid;
					break;
				case ControlType.LISTVIEW:
					MetaListView metaListView = (MetaListView) metaComponent;
					if (metaListView.getTableKey().equals(tableKey))
						return metaListView;
					break;
				case ControlType.EDITVIEW:
				case ControlType.TILEDLIST:
				case ControlType.GALLERY:
				case ControlType.ROTATOR:
				case ControlType.ROTATORLIST:
				case ControlType.WATERFALL:
					MetaEditView metaEditView = (MetaEditView) metaComponent;
					if (metaEditView.getTableKey().equals(tableKey))
						return metaEditView;
					break;
				case ControlType.TABLEVIEW:
					MetaTableView metaTableView = (MetaTableView) metaComponent;
					for (MetaTableRow metaTableRow : metaTableView.getRows().getList()) {
						if (metaTableRow.getRowType() == RowType.Detail) {
							if (!metaTableRow.getTableKey().isEmpty() && metaTableRow.getTableKey().equals(tableKey)) {
								return metaTableView;
							}
						}
					}
					break;
				case ControlType.ATTACHMENT:
					MetaAttachment metaAttachment = (MetaAttachment) metaComponent;
					if (metaAttachment.getTableKey().equals(tableKey))
						return metaAttachment;
					break;
				default:
					if (tableKey.equals(metaComponent.getTableKey())) // 有问题
						return metaComponent;
			}
		}
		return null;
	}

	public MetaGridCell getCellByDataBinding(String tableKey, String columnKey) {
		return this.bindingMap.getCellByDataBinding(tableKey, columnKey);
	}

	public MetaComponent getComponentByDataBinding(String tableKey, String columnKey) {
		return this.bindingMap.getComponentByDataBinding(tableKey, columnKey);
	}

	public MetaListViewColumn getLvColumnByDataBinding(String tableKey, String columnKey) {
		return this.bindingMap.getLvColumnByDataBinding(tableKey, columnKey);
	}

	public MetaEditViewColumn getEvColumnByDataBinding(String tableKey, String columnKey) {
		return this.bindingMap.getEvColumnByDataBinding(tableKey, columnKey);
	}

	/**
	 * 从配置中取得主表单标记，必须是Body下的第一个，因为应用程序不支持嵌入的html
	 *
	 * @return 表单标记元数据
	 */
	public MetaBlock getPrimaryBlock() {
		for (int i = 0, size = metaBody.size(); i < size; i++) {
			AbstractMetaObject metaChild = metaBody.get(i);
			if (metaChild instanceof MetaBlock) {
				MetaBlock metaBlock = (MetaBlock) metaChild;
				if (metaBlock.isRoot()) {
					return metaBlock;
				}
			}
		}
		return null;
	}

	@Override
	public void merge(MetaForm metaForm) {
		if (this.caption == null) {
			this.caption = metaForm.getCaption();
		}
		if (this.captionEn == null) {
			this.captionEn = metaForm.getCaptionEn();
		}
		if (this.formType == -1) {
			this.formType = metaForm.getFormType();
		}
		if (this.initState == -1) {
			this.initState = metaForm.getInitState();
		}
		if (this.authenticate == null) {
			this.authenticate = metaForm.isAuthenticate();
		}
		if (this.formulaCaption == null) {
			this.formulaCaption = metaForm.getFormulaCaption();
		}
		if (this.abbrCaption == null) {
			this.abbrCaption = metaForm.getAbbrCaption();
		}
		if (this.formulaAbbrCaption == null) {
			this.formulaAbbrCaption = metaForm.getFormulaAbbrCaption();
		}
		if (this.viewKey == null) {
			this.viewKey = metaForm.getViewKey();
		}
		if (this.linkedFormKey == null) {
			this.linkedFormKey = metaForm.getLinkedFormKey();
		}
		if (this.description == null) {
			this.description = metaForm.getDescription();
		}
		if (this.platform == -1) {
			this.platform = metaForm.getPlatform();
		}
		if (this.confirmClose == null) {
			this.confirmClose = metaForm.isConfirmClose();
		}
		if (this.useVariant == null) {
			this.useVariant = metaForm.isUseVariant();
		}
		if (this.onLoad == null) {
			this.onLoad = metaForm.getOnLoad() == null ? null : (MetaBaseScript) metaForm.getOnLoad().clone();
		}
		if (this.onClose == null) {
			this.onClose = metaForm.getOnClose() == null ? null : (MetaBaseScript) metaForm.getOnClose().clone();
		}
		if (this.onPostShow == null) {
			this.onPostShow = metaForm.getOnPostShow() == null ? null
					: (MetaBaseScript) metaForm.getOnPostShow().clone();
		}
		if (statusBarColor == null) {
			statusBarColor = metaForm.getStatusBarColor();
		}
		if (offLine == null) {
			offLine = metaForm.isOffLine();
		}
		if (this.metaBody != null) {
			this.metaBody.merge(metaForm.getMetaBody());
		}
		MetaQueryCollection queryCollection = metaForm.getQueryCollection();
		if (queryCollection != null) {
			if (this.queryCollection == null) {
				this.queryCollection = (MetaQueryCollection) queryCollection.depthClone();
			} else {
				this.queryCollection.merge(queryCollection);
			}
		}

		MetaScriptCollection scriptCollection = metaForm.getScriptCollection();
		if(scriptCollection != null) {
			if(this.scriptCollection != null) {
				this.scriptCollection = (MetaScriptCollection)scriptCollection.depthClone();
			}else {
				for(MetaScript metaScript : scriptCollection) {
					String key = metaScript.getKey();
					MetaScript meta1 = this.scriptCollection.get(key);
					if(meta1 != null) {
						meta1.merge(metaScript);
					}else {
						this.scriptCollection.add(meta1);
					}
				}
			}
		}
		if (sourceForm == null) {
			sourceForm = metaForm.getSourceForm();
		}
		if (deliveryClass == null) {
			deliveryClass = metaForm.getDeliveryClass();
		}
		if (transFormKey == null) {
			transFormKey = metaForm.getTransFormKey();
		}
		if (metaForm.getExtend().isEmpty()){
		if (this.optCollection == null){
			if (metaForm.getOperationCollection()!=null){

				this.optCollection = (MetaOperationCollection) metaForm.getOperationCollection().depthClone();
			}
		} else {
			mergerOperationCollection(this.getOperationCollection(),metaForm.getOperationCollection());//合并原单内容
			MetaOperationCollection traces = (MetaOperationCollection) metaForm.getOperationCollection().depthClone();

			toMergerOperationCollection(traces, this.optCollection );//合并马甲内容

			this.optCollection = traces;
			//反向合并初始化新增列
			for (KeyPairCompositeObject compositeObject : this.optCollection) {
				if (compositeObject instanceof MetaOperationCollection) {
					((MetaOperationCollection) compositeObject).merge(new MetaOperationCollection());
					for (KeyPairCompositeObject keyPairCompositeObject : ((MetaOperationCollection) compositeObject)) {
						((MetaOperation) keyPairCompositeObject).merge(new MetaOperation());
					}
				} else {
					((MetaOperation) compositeObject).merge(new MetaOperation());
				}
			}

		}
		}
		// 源单的数据源不为空,才需要处理
		MetaDataSource dataSource = metaForm.getDataSource();
		if (dataSource != null) {
			if (this.dataSource == null) {
				this.dataSource = (MetaDataSource) dataSource.clone();
			} else {
				if (this.dataSource.getRefObjectKey() != null && !this.dataSource.getRefObjectKey().isEmpty() && this.getMergeToSource()) {
					return;//不知道谁写的这么坑
				} else if (this.getMergeToSource()) {
					this.dataSource.merge4Diff(dataSource);
				} else {
					this.dataSource.merge(dataSource);
				}

			}
		}
	}
	private void mergerOperationCollection(MetaOperationCollection operationCollection, MetaOperationCollection extOperationCollection) {
		if (extOperationCollection != null) {
			for (KeyPairCompositeObject keyPairCompositeObject : extOperationCollection) {
				KeyPairCompositeObject keyPairCompositeObject1 = operationCollection.get(keyPairCompositeObject.getKey());
				if (keyPairCompositeObject1 != null) {//找到源
					if (keyPairCompositeObject1 instanceof MetaOperationCollection) {
						MetaOperationCollection collections = (MetaOperationCollection) keyPairCompositeObject1;
						collections.merge((MetaOperationCollection) keyPairCompositeObject);
						for (KeyPairCompositeObject collection :  (MetaOperationCollection)keyPairCompositeObject) {
							KeyPairCompositeObject keyPairCompositeObject2 = collections.get(collection.getKey());
							if (keyPairCompositeObject2 != null) {
								MetaOperation collections2 = (MetaOperation) keyPairCompositeObject2;
								collections2.merge((MetaOperation) collection);
							}
						}
					}else {
						MetaOperation collections = (MetaOperation) keyPairCompositeObject1;
						collections.merge((MetaOperation) keyPairCompositeObject);
					}
				}
			}
		}
	}
	private void toMergerOperationCollection(MetaOperationCollection operationCollection, MetaOperationCollection extOperationCollection) {
		if (extOperationCollection != null) {
			for (KeyPairCompositeObject keyPairCompositeObject : extOperationCollection) {
				KeyPairCompositeObject keyPairCompositeObject1 = operationCollection.get(keyPairCompositeObject.getKey());
				if (keyPairCompositeObject1 != null) {//找到源
					if (keyPairCompositeObject1 instanceof MetaOperationCollection) {
						MetaOperationCollection collections = (MetaOperationCollection) keyPairCompositeObject1;
						collections.toMerge((MetaOperationCollection) keyPairCompositeObject);
						MetaOperationCollection collection1 = (MetaOperationCollection) keyPairCompositeObject;
						if (collections.size() == 0){
							operationCollection.add((KeyPairCompositeObject) collection1.depthClone());

						}else {
							toMergerOperationCollection(collections,collection1);
						}
					} else {
						MetaOperation collections = (MetaOperation) keyPairCompositeObject1;
						collections.toMerge((MetaOperation) keyPairCompositeObject);
					}
				} else {
					operationCollection.add((KeyPairCompositeObject) keyPairCompositeObject.depthClone());
				}
			}
		}
	}
	/**
	 * 将根控件及其所有子控件添加到明细控件列表
	 * @param detailCompMap 明细控件列表
	 * @param root 明细控件的根控件
	 * @param keySet 记录所有控件key，防止控件key重复
	 * @param listTableKey 明细控件所在列表控件的tablekey
	 * @throws MetaException
	 */
	private void addRootDetailComp(StringHashMap<MetaComponent> detailCompMap, MetaComponent root,
								   HashSet<String> keySet, String listTableKey) throws MetaException {
		if (root == null) {
			return;
		}

		String tmpKey = root.getKey();
		if (keySet.contains(tmpKey)) {
			throw new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatComponentCellKey),
							this.key, tmpKey, this.resource));
		}
		keySet.add(tmpKey);

		String columnKey = root.getColumnKey();
		if(columnKey != null && !columnKey.isEmpty()){
			MetaDataObject dataObject = dataSource == null ? null : dataSource.getDataObject();
			String tableKey = root.getTableKey();
			if(tableKey == null || tableKey.isEmpty()){
				tableKey = listTableKey;
			}
			doDataBindingProcess(dataObject, root, tableKey, columnKey);
		}

		detailCompMap.put(root.getKey(), root);
		addPromptImage(root);
		for(int i=0;i<root.getComponentCount();i++){
			MetaComponent child = root.getComponent(i);
			addRootDetailComp(detailCompMap, child, keySet, listTableKey);
		}
	}

	@Override
	public AbstractMetaObject depthClone() {
		MetaForm metaForm = (MetaForm) super.depthClone();
		metaForm.setProject(this.project);
		return metaForm;
	}

	private void checkComponentKey(String msg){
		throw new MetaException(MetaException.REPEAT_COMPONENT_CELL_KEY,msg);
	}
}