package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaColumnBinding extends KeyPairMetaObject {
	/** 列标识 */
	private String key = "";
	/** 默认值表达式 */
	private String defaultFormulaValue = "";
	
	public MetaColumnBinding() {
		super();
	}
	
	/**
	 * 设置列标识
	 * @param key 列标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置默认值表达式
	 * @param defaultFormulaValue 默认值表达式
	 */
	public void setDefaultFormulaValue(String defaultFormulaValue) {
		this.defaultFormulaValue = defaultFormulaValue;
	}
	
	/**
	 * 取得默认值表达式
	 * @return 默认值表达式
	 */
	public String getDefaultFormulaValue() {
		return this.defaultFormulaValue;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "ColumnBinding";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaColumnBinding newObject = (MetaColumnBinding)newInstance();
		newObject.setKey(key);
		newObject.setDefaultFormulaValue(defaultFormulaValue);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaColumnBinding();
	}

}
