package com.bokesoft.yigo.meta.flatcanvas.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.xml.XmlContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.node.AbstractMetaFCObject;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCPaper;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCSection;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCSectionCollection;

/**
 * 
 * 平面图配置对象工具类
 * 
 * @author chenbinbin
 *
 */

public class FCDomUtil {

	/**
	 * 从文件中获取区域集合
	 * 
	 * @param file 文件句柄
	 * 
	 * @return 区域集合
	 */
	public static MetaFCSectionCollection loadSectionCollection(File file) {
		MetaFCSectionCollection sectionModels = new MetaFCSectionCollection();
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db;
		try {
			db = dbf.newDocumentBuilder();
			Document doc = db.parse(file);
			Element elem = doc.getDocumentElement();
			sectionModels.loadFromElement(elem);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return sectionModels;
	}
	
	/**
	 * 从文件加载平面图配置对象
	 * 
	 * @param file 文件句柄
	 * @return 平面图配置对象
	 */
	public static MetaFCPaper loadPaper(File file) {
		MetaFCPaper paperModel = new MetaFCPaper();
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db;
		try {
			db = dbf.newDocumentBuilder();
			Document doc = db.parse(file);
			Element elem = doc.getDocumentElement();
			paperModel.loadFromElement(elem);

		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return paperModel;
	}

	/**
	 * 将平面图配置对象保存为xml文件
	 * 
	 * @param paperModel 平面图配置对象
	 * @param file 		  文件句柄
	 * 
	 */
	public static void save(MetaFCPaper paperModel, File file) {
		try {
			DocumentBuilder dombuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document doc = dombuilder.newDocument();
			IContentHandler handler = new XmlContentHandler(doc);
			paperModel.saveTo(handler, handler.getRoot());

			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty("encoding", "utf8");
			transformer.setOutputProperty("indent", "yes");
			DOMSource source = new DOMSource(doc);
			transformer.transform(source, new StreamResult(file));

		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 将平面图中涉及到的任意配置对象转化成xml格式文本
	 * 
	 * @param fcMeta 平面图中涉及到的任意配置对象
	 * 
	 * @return 配置对象的xml文本
	 */
	public static String model2String(AbstractMetaFCObject fcMeta) {
		try {
			DocumentBuilder dombuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document doc = dombuilder.newDocument();
			IContentHandler handler = new XmlContentHandler(doc);
			fcMeta.saveTo(handler, handler.getRoot());
			StringWriter sw = new StringWriter();
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			DOMSource source = new DOMSource(doc);
			transformer.transform(source, new StreamResult(sw));
			return sw.toString();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		}
		return "";
	}
	
	/**
	 * xml文本转化成平面图中的配置对象
	 * 
	 * @param sXmlStr	xml文本
	 * 
	 * @return 平面图中的配置对象
	 * 
	 */
	public static AbstractMetaFCObject string2Model(String sXmlStr) {
		MetaFCSection sectionModel = new MetaFCSection();
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db;
		try {
			StringReader sr = new StringReader(sXmlStr);
			InputSource is = new InputSource(sr);
			db = dbf.newDocumentBuilder();
			Document doc = db.parse(is);
			Element elem = doc.getDocumentElement();
			sectionModel.loadFromElement(elem);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return sectionModel;
	}

}
