package com.bokesoft.yigo.meta.flatcanvas.convertor;

/**
 * 配置对象转储接口
 * 
 * @author chenbinbin
 *
 */
public interface IContentHandler {

	/**
	 * 创建子节点
	 * 
	 * @param tagName 节点标识
	 * @param isCollection 是否集合标志
	 * @return 节点
	 */
	public INode createNode(String tagName, boolean isCollection);
	
	/**
	 * 获取根节点
	 * 
	 * @return 根节点
	 */
	public INode getRoot();
	
	/**
	 * 获取节点内容, 文本格式
	 * 
	 * @return 节点的内容
	 */
	public String getContent();
	
}
