package com.bokesoft.yigo.meta.flatcanvas.common;

import java.util.LinkedHashMap;
import java.util.Map.Entry;
import java.util.Observable;
import java.util.Set;

/**
 * 平面图节点属性集合
 * 
 * @author chenbinbin
 *
 */
public class Attributes extends Observable implements IChangeListener {

	/** 属性项集合 */
	private LinkedHashMap<String, AttributeItem> attrs = null;
	
	public Attributes() {
		attrs = new LinkedHashMap<String, AttributeItem>();
	}
	
	/**
	 * 设置属性值
	 * 
	 * @param attrName 属性名
	 * @param value 属性值
	 */
	public void set(String attrName, Object value) {
		AttributeItem item = attrs.get(attrName);
		if (item == null) {
			item = new AttributeItem(attrName, null);
			attrs.put(attrName, item);
			item.setChangeListener(this);
		} 
		item.setValue(value);
	}
	
	/**
	 * 获取属性值
	 * 
	 * @param attrName 属性名
	 * 
	 * @return 属性值
	 */
	public Object get(String attrName) {
		if (!attrs.containsKey(attrName)) {
			return null;
		}
		return attrs.get(attrName).getValue();
	}
	
	/**
	 * 添加属性
	 * 
	 * @param attrItem 属性
	 */
	public void addAttrItem(AttributeItem attrItem) {
		if (attrItem == null)
			return;
		attrs.put(attrItem.getKey(), attrItem);
	}
	
	/**
	 * 获取属性项
	 * 
	 * @param attrName 属性名
	 * 
	 * @return 属性项
	 */
	public AttributeItem getAttrItem(String attrName) {
		return attrs.get(attrName);
	}
	
	/**
	 * 判读是否包含某个属性
	 * 
	 * @param attrName 属性名
	 * 
	 * @return 是否包含某个属性
	 */
	public boolean containsKey(String attrName) {
		return attrs.containsKey(attrName);
	}

	/**
	 * 移除某个属性
	 * 
	 * @param attrName 属性名
	 */
	public void remove(String attrName) {
		attrs.remove(attrName);
	}
	
	/**
	 * 遍历属性
	 * 
	 * @return 属性集合
	 */
	public Set<Entry<String, AttributeItem>> entrySet() {
		return attrs.entrySet();
	}

	@Override
	public void fireChanged() {
		this.setChanged();
		this.notifyObservers();
	}
}
