package com.bokesoft.yigo.meta.flatcanvas;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCPaper;
import com.bokesoft.yigo.meta.intf.IMetaProject;

/**
 * 平面图文件对象
 * 
 * @author chenbinbin
 *
 */
public class MetaFlatCanvasProfile extends KeyPairMetaObject  {
	
	public static final String TAG_NAME = "Paper";
	
	/** 数据对象标识 */
	private String key = null;
	/** 数据对象名称 */
	private String caption = null;
	/** 资源路径 */
	private String resource = null;
	/** 平面图对象 */
	private MetaFCPaper metaPaper = null;
	
	/** 工程对象引用 */
	private IMetaProject project = null;

	public MetaFlatCanvasProfile() {
		super();
	}
	
	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	/**
	 * 设置数据对象标识
	 * @param key 数据对象标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置数据对象名称
	 * @param caption 数据对象名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得数据对象名称
	 * @return 数据对象名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置资源路径
	 * @param resource 资源路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	
	/**
	 * 取得资源路径
	 * @return 资源路径
	 */
	public String getResource() {
		return this.resource;
	}

	/**
	 * 设置平面图配置对象
	 * 
	 * @param metaPaper 平面图配置对象
	 */
	public void setMetaPaper(MetaFCPaper metaPaper) {
		this.metaPaper = metaPaper;
	}
	

	/**
	 * 获取平面图配置对象
	 * 
	 * @return 平面图配置对象
	 */
	public MetaFCPaper getMetaPaper() {
		return this.metaPaper;
	}
	
	/**
	 * 设置工程对象引用
	 * @param project 工程对象
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	/**
	 * 取得工程对象引用
	 * @return 工程对象
	 */
	public IMetaProject getProject() {
		return this.project;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaFlatCanvasProfile newObject = new MetaFlatCanvasProfile();
		newObject.setKey(key);
		newObject.setCaption(caption);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFlatCanvasProfile();
	}
}
