package com.bokesoft.yigo.meta.factory.workflow;

import java.util.HashMap;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.factory.workflow.source.IProcessSource;
import com.bokesoft.yigo.meta.factory.workflow.source.ProcessDefinationDB;
import com.bokesoft.yigo.meta.factory.workflow.source.ProcessDefinationDirectory;

public class ProcessSourceFactory {

	private HashMap<String, IMetaResolver> projectResolverMap = null;
	private ProcessDefinitionProfile profile = null;
	
	public ProcessSourceFactory(HashMap<String, IMetaResolver> projectResolverMap, ProcessDefinitionProfile profile) {
		this.projectResolverMap = projectResolverMap;
		this.profile = profile;
	}
	
	public IProcessSource getProcessSource(){
		String sourceType = profile.getSourceType();
		String uniqueKey = profile.getKey() + "_V" + profile.getVersion();
		IProcessSource processSource = ProcessSourceMapContainer.getInstance().getProcessSourceMap().get(uniqueKey);
		if(processSource != null){
			return processSource;
		}
		
		if(ProcessSourceType.DB.equalsIgnoreCase(sourceType)){
			processSource = new ProcessDefinationDB(profile.getJsonUnserializer());
		}else if(ProcessSourceType.DIRECTORY.equalsIgnoreCase(sourceType)){
			processSource = new ProcessDefinationDirectory(projectResolverMap, profile);
		}
		
		return processSource;
	}
}
