package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtPostExportService extends GenericKeyCollection<MetaPostExportService> implements IElementMerge<MetaExtPostExportService>{
	public static final String TAG_NAME = "ExtPostExportService";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaPostExportService.TAG_NAME.equals(tagName)){
			MetaPostExportService service = new MetaPostExportService();
			service.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(service);
			resultMetaObject = service;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtPostExportService();
	}

	@Override
	public MetaExtPostExportService toMerge(MetaExtPostExportService obj) {
		if (obj != null) {
			Iterator<MetaPostExportService> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaPostExportService metaPostExportService = (MetaPostExportService) iterator.next();
				if (containsKey(metaPostExportService.getKey())) {
					throw new MetaException(MetaException.REPEAT_EXT_POST_EXPORT_SERVICE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatExtPostExportServiceDefined),
									metaPostExportService.getKey()));
				}
				add(metaPostExportService);
			}
		}
		return this;
	}
}
