package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtExportService extends GenericKeyCollection<MetaExportService> implements IElementMerge<MetaExtExportService> {
	public static final String TAG_NAME = "ExtExportService";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaExportService.TAG_NAME.equals(tagName)){
			MetaExportService service = new MetaExportService();
			service.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(service);
			resultMetaObject = service;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtExportService();
	}

	@Override
	public MetaExtExportService toMerge(MetaExtExportService obj) {
		if (obj != null) {
			Iterator<MetaExportService> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaExportService metaExportService = (MetaExportService) iterator.next();
				if (containsKey(metaExportService.getKey())) {
					throw new MetaException(MetaException.REPEAT_EXT_EXPORT_SERVICE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatExtExportServiceDefined),
									metaExportService.getKey()));
				}
				add(metaExportService);
			}
		}
		return this;
	}
}
