package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtDocumentService extends GenericKeyCollection<MetaDocumentService> implements IElementMerge<MetaExtDocumentService> {

	public static final String TAG_NAME = "ExtDocumentService";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaDocumentService.TAG_NAME.equals(tagName)){
			MetaDocumentService metaDocumentService = new MetaDocumentService();
			metaDocumentService.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaDocumentService);
			resultMetaObject = metaDocumentService;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtDocumentService();
	}

	@Override
	public MetaExtDocumentService toMerge(MetaExtDocumentService obj) {
		if (obj != null) {
			Iterator<MetaDocumentService> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaDocumentService metaDocumentService = (MetaDocumentService) iterator.next();
				if (containsKey(metaDocumentService.getKey())) {
					throw new MetaException(MetaException.REPEAT_EXT_SERVICE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatExtServiceDefined),
									metaDocumentService.getKey()));
				}
				add(metaDocumentService);
			}
		}
		return this;
	}

}

