package com.bokesoft.yigo.meta.diff.util;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.impl.IDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffActionMap;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffContextFactory;
import com.bokesoft.yigo.meta.diff.impl.IDiffFactoryBuilder;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaActionMapFactory;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IMetaElementFactory;

public class DiffActionManager {
	
	private static String DIFF_FACTORY_BUILDER = "com.bokesoft.yigo.meta.diff.base.DiffFactoryBuilder";
	
	private static DiffActionManager instance = new DiffActionManager();
	
	private IDiffFactoryBuilder factoryBuilder = null;

	private IDiffActionMap actionFactory = null;
	
	private IDiffContextFactory contextFactory = null;
	
	private IMetaElementFactory elementFactory = null;
	
	private IDiffMetaActionMapFactory metaActionMapFactory = null;
	
	private DiffActionManager() {
		init();
	}
	
	private void init() {
		try {
			factoryBuilder = (IDiffFactoryBuilder) Class.forName(DIFF_FACTORY_BUILDER).newInstance();
			actionFactory = factoryBuilder.buildDiffActionFactory();
			contextFactory = factoryBuilder.buildContextFactory();
			elementFactory = factoryBuilder.buildMetaElementFactory();
			metaActionMapFactory = factoryBuilder.buildMetaActionMap();
		} catch (Exception e) {
			System.out.println(e.getMessage());
			// e.printStackTrace();
		}
	}
	
	public boolean isInited() {
		return factoryBuilder != null;
	}
	
	public MetaActionMap getMetaActionInstance(Class<?> cls) {
		if (metaActionMapFactory == null) {
			return null;
		}
		return metaActionMapFactory.getMetaActionInstance(cls);
	}
	
	/**
	 * 根据TagName创建Meta对象
	 * @param tagName
	 * @param env
	 * @return
	 */
	public AbstractMetaObject createMetaElement(String tagName, IMetaEnv env) {
		if (elementFactory != null) {
			return elementFactory.create(tagName, env);
		}
		return null;
	}
	
	/**
	 * 分离差异入口 
	 *  
	 * @param key
	 * @param oldMeta
	 * @param newMeta
	 * @param metaDiff
	 * @param env
	 * @throws Exception
	 */
	public <T extends AbstractMetaObject> void doDiffDivideAction(String key, T oldMeta, T newMeta, 
			MetaDiff metaDiff, IDiffMetaEnv env) throws Exception {
		if (actionFactory == null || oldMeta == null) return;
		IDiffContext context = contextFactory.createDiffContext(oldMeta, actionFactory, env);
		IDiffAction<AbstractMetaObject> diffAction = actionFactory.getDiffAction(oldMeta);
		if (diffAction != null) {
			diffAction.doDivide(key, oldMeta, newMeta, metaDiff, null, null, context);
		}
	}
	
	/**
	 * 合并差异入口 
	 * @param baseMeta
	 * @param metaDiff
	 * @param env
	 * @throws Exception
	 */
	public <T extends AbstractMetaObject> void doDiffMergeAction(T baseMeta, MetaDiff metaDiff, IMetaEnv env) throws Exception {
		if (baseMeta == null || metaDiff == null || actionFactory == null) return;
		IDiffContext context = contextFactory.createDiffContext(baseMeta, actionFactory, env);
		IDiffAction<AbstractMetaObject> diffAction = actionFactory.getDiffAction(baseMeta);
		if (diffAction != null) {
			diffAction.doMerge(metaDiff, baseMeta, null, null, context);
		}
	}
	
	public static DiffActionManager getInstance() {
		return instance;
	}
}
