package com.bokesoft.yigo.meta.diff.impl;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaMove;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;

public interface IMergeDiffAction {
	
	default void mergeBase(AbstractMetaObject meta) throws Exception {};
	
	default void mergeUpdate(AbstractMetaObject meta) {};
	
	default void mergeDelete(MetaDelete meta) {};

	default void mergeAdd(MetaAdd meta) {};
	
	/**
	 * 表格列,单元格需要根据index添加
	 */
	default void mergeAdd(KeyPairMetaObject meta, int index) {};
	/**
	 * 合并单个移动
	 * @param move
	 */
	default void mergeMove(MetaMove meta) {};
	/**
	 * 合并移动
	 * @param moveCollection
	 */
	default boolean mergeMoveCollection(MetaMoveCollection moveCellection) {return false;};
}
