package com.bokesoft.yigo.meta.diff.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.diff.MetaMove;

public class MetaMoveAction extends BaseDomAction<MetaMove> {
	@Override
	public void load(Document document, Element element, MetaMove meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setIndexOffSet(DomHelper.readAttr(element, "IndexOffSet", 0));
		meta.setTargetContainerKey(DomHelper.readAttr(element, MetaConstants.DIFF_TARGET_CONTAINER_KEY, ""));
		meta.setMoveTag(DomHelper.readAttr(element,  MetaConstants.DIFF_MOVE_TAG, ""));
		meta.setPreviousKey(DomHelper.readAttr(element, MetaConstants.DIFF_PREVIOUS_KEY, ""));
		meta.setParentTag(DomHelper.readAttr(element, MetaConstants.Diff_PARENT_TAG, ""));
	}

	@Override
	public void save(Document document, Element element, MetaMove meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, "IndexOffSet", meta.getIndexOffSet(), 0);
		DomHelper.writeAttr(element, MetaConstants.DIFF_TARGET_CONTAINER_KEY, meta.getTargetContainerKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DIFF_MOVE_TAG, meta.getMoveTag(), "");
		DomHelper.writeAttr(element, MetaConstants.DIFF_PREVIOUS_KEY, meta.getPreviousKey(), "");
		DomHelper.writeAttr(element, MetaConstants.Diff_PARENT_TAG, meta.getParentTag(), "");
	}

}
