package com.bokesoft.yigo.meta.diff.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.diff.MetaIndex;

public class MetaIndexAction extends BaseDomAction<MetaIndex> {

	@Override
	public void load(Document document, Element element, MetaIndex meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, null));
		meta.setIndex(DomHelper.readAttr(element, MetaConstants.COMMON_INDEX, -1));
	}

	@Override
	public void save(Document document, Element element, MetaIndex meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), null);
		DomHelper.writeAttr(element, MetaConstants.COMMON_INDEX, meta.getIndex(), -1);
	}

}
