package com.bokesoft.yigo.meta.diff.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.diff.MetaDelete;

public class MetaDeleteAction extends BaseDomAction<MetaDelete> {
	@Override
	public void load(Document document, Element element, MetaDelete meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDeleteTag(DomHelper.readAttr(element, "DeleteTag", ""));
		meta.setParentTag(DomHelper.readAttr(element, MetaConstants.Diff_PARENT_TAG, ""));
	}

	@Override
	public void save(Document document, Element element, MetaDelete meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, "DeleteTag", meta.getDeleteTag(), "");
		DomHelper.writeAttr(element, MetaConstants.Diff_PARENT_TAG, meta.getParentTag(), "");
	}

}

