package com.bokesoft.yigo.meta.diff;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaDiffProfile extends KeyPairMetaObject {
	/** 标题*/
	private String key = "";
	/** 名称*/
	private String caption = "";
	/** 资源所在目录 */
	private String path = null;
	/** 资源全路径 */
	private String resource = null;

	/** 持有的配置对象*/
	private MetaDiff metaDiff = null;
	/** 所在工程引用*/
	private IMetaProject project = null;
	
	public MetaDiffProfile() {
		super();
	}
	
	public static final String TAG_NAME = "Diff";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置资源所在目录
	 * @param path 目录
	 */
	public void setPath(String path) {
		this.path = path;
	}
	
	/**
	 * 取得资源所在目录
	 * @return 目录
	 */
	public String getPath() {
		return this.path;
	}
	
	/**
	 * 设置资源全路径
	 * @param resource 资源全路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	
	/**
	 * 取得资源全路径
	 * @return 资源全路径
	 */
	public String getResource() {
		return this.resource;
	}
	
	public void setDiff(MetaDiff metaDiff) {
		this.metaDiff = metaDiff;
	}
	
	public MetaDiff getDiff() {
		return metaDiff;
	}
	
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	public IMetaProject getProject() {
		return project;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaDiffProfile newObject = new MetaDiffProfile();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setResource(resource);
		newObject.setDiff((MetaDiff) this.metaDiff.clone());
		newObject.setProject(project);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDiffProfile();
	}
}
