package com.bokesoft.yigo.meta.diff;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.diff.util.DiffActionManager;

// GenericKeyCollection MetaGridRow needPreLoad=false 加载时会覆盖
public class MetaDeleteCollection extends GenericNoKeyCollection<MetaDelete> {
	
	private MetaIndexCollection indexCollection;
	
	public static final String TAG_NAME = "DeleteCollection";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if( indexCollection != null ) {
			list.add(indexCollection);
		}
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public MetaIndexCollection getIndexCollection() {
		return indexCollection;
	}

	public void setIndexCollection(MetaIndexCollection indexCollection) {
		this.indexCollection = indexCollection;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject meta = null;
		if( tagName.equals(MetaIndexCollection.TAG_NAME) ) {
			this.indexCollection = new MetaIndexCollection();
			meta = this.indexCollection;
		} else if(tagName.equals(MetaDelete.TAG_NAME) ) {
			meta = new MetaDelete();
			meta.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaDelete) meta);
		} else {
			// 兼容之前版本的删除记录方式, 对现有版本无用
			AbstractMetaObject tmpMeta = DiffActionManager.getInstance().createMetaElement(tagName, env);
			tmpMeta.traversalSingle(env, doc, node, flag, runType);
			//tmpMeta.preProcessMetaObject(env, doc, node, flag, runType);
			if (tmpMeta instanceof KeyPairMetaObject) {
				String key = ((KeyPairMetaObject) tmpMeta).getKey();
				meta = new MetaDelete(key, tagName, "");
				this.add((MetaDelete) meta);
			}
			
		}
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDeleteCollection();
	}

}
