package com.bokesoft.yigo.meta.diff;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.diff.util.DiffActionManager;

public class MetaAdd extends KeyPairMetaObject {
	
	public static final String TAG_NAME = "Add";
	
	private AbstractMetaObject meta = null;
	
	// 节点标识
	private String key = null;
	
	private String containerKey = "";
	
	private String containerTag = "";
	
	private String previousKey = "";
	
	public MetaAdd() {
	}
	
	public MetaAdd(String key) {
		this.key = key;
	}
	
	public String getPreviousKey() {
		return previousKey;
	}

	public void setPreviousKey(String previousKey) {
		this.previousKey = previousKey;
	}
	
	public String getContainerKey() {
		return containerKey;
	}

	public void setContainerKey(String containerKey) {
		this.containerKey = containerKey;
	}

	public String getContainerTag() {
		return containerTag;
	}

	public void setContainerTag(String containerTag) {
		this.containerTag = containerTag;
	}
	
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	public void setBase(AbstractMetaObject meta) {
		this.meta = meta;
	}
	
	public AbstractMetaObject getBase() {
		return this.meta;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(meta);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		this.meta = (AbstractMetaObject) DiffActionManager.getInstance().createMetaElement(tagName, env);
		this.meta.preProcessMetaObject(env, doc, node, flag, runType);
		return meta;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaAdd o = new MetaAdd();
		o.setKey(key);
		o.setContainerKey(containerKey);
		o.setContainerTag(containerTag);
		return o;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAdd();
	}
}