package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 表示查询中的参数
 * 
 * @author 刘翔翔
 *
 */
public class MetaParameter extends AbstractMetaObject {

	public static final String TAG_NAME = "Parameter";

	/** 参数关联的表 */
	private String targetTable = "";
	/** 参数关联的列 */
	private String targetColumn = "";
	/** 参数的来源类型 */
	private Integer sourceType = ParameterSourceType.FORMULA;
	/** 参数的来源公式 */
	private String formula = "";
	/** 来源字段标识 */
	private String fieldKey = "";
	/** 常量值 */
	private String value = "";
	/** 参数的数据类型 */
	private Integer dataType = -1;
	/** 描述 */
	private String description = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaParameter newObject = new MetaParameter();
		newObject.setSourceType(sourceType);
		newObject.setFormula(formula);
		newObject.setTargetColumn(targetColumn);
		newObject.setTargetTable(targetTable);
		newObject.setDataType(dataType);
		newObject.setFieldKey(fieldKey);
		newObject.setValue(value);
		newObject.setDescription(description);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaParameter();
	}

	/**
	 * 设置目标表
	 * 
	 * @param targetTable
	 *            目标表
	 */
	public void setTargetTable(String targetTable) {
		this.targetTable = targetTable;
	}

	/**
	 * 取得目标表
	 * 
	 * @return 目标表
	 */
	public String getTargetTable() {
		return targetTable;
	}

	/**
	 * 设置目标列
	 * 
	 * @param targetColumn
	 *            目标列
	 */
	public void setTargetColumn(String targetColumn) {
		this.targetColumn = targetColumn;
	}

	/**
	 * 取得目标列
	 * 
	 * @return 目标列
	 */
	public String getTargetColumn() {
		return targetColumn;
	}

	/**
	 * 设置来源类型
	 * 
	 * @param sourceType
	 *            来源类型
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	/**
	 * 取得来源类型
	 * 
	 * @return 来源类型
	 */
	public Integer getSourceType() {
		return sourceType;
	}

	/**
	 * 设置字段标识
	 * 
	 * @param fieldKey
	 *            字段标识
	 */
	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}

	/**
	 * 取得字段标识
	 * 
	 * @return 字段标识
	 */
	public String getFieldKey() {
		return this.fieldKey;
	}

	/**
	 * 设置常量值
	 * 
	 * @param value
	 *            常量值
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * 取得常量值
	 * 
	 * @return 常量值
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * 设置表达式
	 * 
	 * @param formula
	 *            表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}

	/**
	 * 取得表达式
	 * 
	 * @return 表达式
	 */
	public String getFormula() {
		return formula;
	}

	/**
	 * 设置数据类型
	 * 
	 * @param dataType
	 *            数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	/**
	 * 取得数据类型
	 * 
	 * @return 数据类型
	 */
	public Integer getDataType() {
		return dataType;
	}

	/**
	 * 设置描述
	 * 
	 * @param description
	 *            描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 取得描述
	 * 
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
}
