package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaStatement;

/**
 * MetaOIDFilter定义数据对象中OID的过滤条件
 * @author wangyh
 *
 */
public class MetaOIDFilter extends AbstractMetaObject {
	/** 过滤的类型 */
	private Integer type = -1;
	/** 表达式 */
	private String formula = "";
	/** 接口实现类 */
	private String impl = "";
	/** 查询语句定义 */
	private MetaStatement statement = null;
	/** 参数集合对象 */
	private MetaParameterCollection parameterCollection = null;
	
	public MetaOIDFilter() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { statement, parameterCollection });
	}

	public static final String TAG_NAME = "OIDFilter";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaStatement.TAG_NAME.equals(tagName) ) {
			this.statement = new MetaStatement();
			resultMetaObject = this.statement;
		} else if ( MetaParameterCollection.TAG_NAME.equals(tagName) ) {
			this.parameterCollection = new MetaParameterCollection();
			resultMetaObject = this.parameterCollection;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置类型
	 * @param type 类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得类型
	 * @return 类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置表达式
	 * @param formula 表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	/**
	 * 取得表达式
	 * @return 表达式
	 */
	public String getFormula() {
		return this.formula;
	}
	
	/**
	 * 设置接口实现类
	 * @param impl 接口实现类
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 取得接口实现类
	 * @return 接口实现类
	 */
	public String getImpl() {
		return this.impl;
	}
	
	/**
	 * 设置查询语句
	 * @param statement 查询语句
	 */
	public void setStatement(MetaStatement statement) {
		this.statement = statement;
	}
	
	/**
	 * 取得查询语句
	 * @return 查询语句
	 */
	public MetaStatement getStatement() {
		return this.statement;
	}
	
	/**
	 * 设置参数集合
	 * @param parameterCollection 参数集合
	 */
	public void setParameterCollection(MetaParameterCollection parameterCollection) {
		this.parameterCollection = parameterCollection;
	}
	
	/**
	 * 取得参数集合
	 * @return 参数集合
	 */
	public MetaParameterCollection getParameterCollection() {
		return this.parameterCollection;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaOIDFilter newObject = (MetaOIDFilter)newInstance();
		newObject.setType(type);
		newObject.setFormula(formula);
		newObject.setImpl(impl);
		newObject.setStatement(statement != null ? (MetaStatement)statement.clone() : null);
		newObject.setParameterCollection(parameterCollection != null ? (MetaParameterCollection)parameterCollection.clone() : null);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaOIDFilter();
	}

}
