package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.HistoryTarget;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaHistory extends AbstractMetaObject {
	/** 是否支持历史版本管理，取值为True和False，默认为False，即不支持历史版本管理*/
	private Boolean support = false;
	
	/** 历史版本的存储目标*/
	private Integer target = HistoryTarget.DB;
	
	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = "History";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	public Boolean isSupport() {
		return support;
	}

	public void setSupport(Boolean support) {
		this.support = support;
	}

	public Integer getTarget() {
		return target;
	}

	public void setTarget(Integer target) {
		this.target = target;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaHistory metaHistory = new MetaHistory();
		metaHistory.setSupport(support);
		metaHistory.setTarget(target);
		return metaHistory;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHistory();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}
	
}
