package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaEmbedVarCollection;

/**
 * MetaEmbedTable定义表的模板，主要说明来源于哪个数据对象中的哪些表
 * @author wangyh
 *
 */
public class MetaEmbedTable extends AbstractMetaObject {
	/** 来源数据对象标识 */
	private String objectKey = "";
	/** 来源表集合 */
	private String tableKeys = "";
	/** 变量集合 */
	private MetaEmbedVarCollection vars = null;
	
	public MetaEmbedTable() {
		this.vars = new MetaEmbedVarCollection();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(vars);
	}

	public static final String TAG_NAME = "EmbedTable";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = vars.createChildMetaObject(env, doc, node, tagName, flag, runType);
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaEmbedTable newObject = (MetaEmbedTable)newInstance();
		newObject.setObjectKey(objectKey);
		newObject.setTableKeys(tableKeys);
		newObject.setVars(vars == null ? null : (MetaEmbedVarCollection)vars.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEmbedTable();
	}

	/**
	 * 设置来源数据对象标识
	 * @param objectKey 数据对象标识
	 */
	public void setObjectKey(String objectKey) {
		this.objectKey = objectKey;
	}
	
	/**
	 * 取得来源数据对象标识
	 * @return 数据对象标识
	 */
	public String getObjectKey() {
		return this.objectKey;
	}
	
	/**
	 * 取得来源表集合
	 * @param tableKeys 来源表集合
	 */
	public void setTableKeys(String tableKeys) {
		this.tableKeys = tableKeys;
	}
	
	/**
	 * 取得来源表集合
	 * @return 来源表集合
	 */
	public String getTableKeys() {
		return this.tableKeys;
	}
	
	/**
	 * 设置变量集合
	 * @param vars 变量集合
	 */
	public void setVars(MetaEmbedVarCollection vars) {
		this.vars = vars;
	}
	
	/**
	 * 取得变量集合
	 * @return 变量集合
	 */
	public MetaEmbedVarCollection getVars() {
		return this.vars;
	}
}
