package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaDataObjectProfile extends KeyPairMetaObject {
	/** 数据对象标识 */
	private String key = null;
	/** 数据对象名称 */
	private String caption = null;
	/** 资源路径 */
	private String resource = null;
	/** 继承的父数据对象*/
	private String extend = null;
	/** 数据对象元数据 */
	private MetaDataObject dataObject = null;
	/** 工程对象引用 */
	private IMetaProject project = null;
	/** 数据对象定义所在的表单  */
	private String formKey = "";
	/** 数据对象的主类型 */
	private Integer primaryType = DataObjectPrimaryType.VIRTUAL;
	/**
	 * 数据对象的辅助类型；PrimayType取值为Entity时，取值范围为见
	 * {@link com.bokesoft.yigo.common.def.DataObjectSecondaryType}
	 */
	private Integer secondaryType = DataObjectSecondaryType.NORMAL;

	public MetaDataObjectProfile() {
		super();
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "DataObject";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
													String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	/**
	 * 设置数据对象标识
	 * @param key 数据对象标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置数据对象名称
	 * @param caption 数据对象名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得数据对象名称
	 * @return 数据对象名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置资源路径
	 * @param resource 资源路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}

	/**
	 * 取得资源路径
	 * @return 资源路径
	 */
	public String getResource() {
		return this.resource;
	}

	/**
	 * 设置数据对象元数据
	 * @param dataObject 数据对象元数据
	 */
	public void setDataObject(MetaDataObject dataObject) {
		this.dataObject = dataObject;
	}

	/**
	 * 取得数据对象元数据
	 * @return 数据对象元数据
	 */
	public MetaDataObject getDataObject() {
		return this.dataObject;
	}

	/**
	 * 设置工程对象引用
	 * @param project 工程对象
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}

	/**
	 * 取得工程对象引用
	 * @return 工程对象
	 */
	public IMetaProject getProject() {
		return this.project;
	}

	/**
	 * 设置表单标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}

	/**
	 * 取得表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return this.formKey;
	}

	/**
	 * 设置数据对象的主类型
	 * @param primaryType 主类型
	 */
	public void setPrimaryType(Integer primaryType) {
		this.primaryType = primaryType;
	}

	/**
	 * 取得数据对象的主类型
	 * @return 主类型
	 */
	public Integer getPrimaryType() {
		return this.primaryType;
	}

	/**
	 * 获取数据对象的辅助类型
	 *
	 * @return 辅助类型
	 */
	public Integer getSecondaryType() {
		return secondaryType;
	}

	/**
	 * 设置数据对象的辅助类型
	 *
	 * @param secondaryType
	 *            辅助类型
	 */
	public void setSecondaryType(Integer secondaryType) {
		this.secondaryType = secondaryType;
	}

	public String getExtend() {
		return extend;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDataObjectProfile newObject = new MetaDataObjectProfile();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setExtend(extend);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataObjectProfile();
	}
}
