package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaCheckRule定义数据对象的检查规则，包含检查的规则和规则说明
 * 
 * @author 王元和
 * @see com.bokesoft.yigo.meta.common.MetaBaseScript
 */
public class MetaCheckRule extends MetaBaseScript {
	/** 规则的文本说明 */
	private String errorInfo = "";
	/** 规则的执行范围 */
	private Integer scope = 0;

	public MetaCheckRule() {
		super(TAG_NAME);
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "CheckRule";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	/**
	 * 设置出错信息
	 * 
	 * @param errorInfo
	 *            出错信息
	 */
	public void setErrorInfo(String errorInfo) {
		this.errorInfo = errorInfo;
	}

	/**
	 * 取得出错信息
	 * 
	 * @return 出错信息
	 */
	public String getErrorInfo() {
		return this.errorInfo;
	}

	public Integer getScope() {
		return scope;
	}

	public void setScope(Integer scope) {
		this.scope = scope;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCheckRule newCheckRule = (MetaCheckRule) super.clone();
		newCheckRule.setErrorInfo(errorInfo);
		newCheckRule.setScope(scope);
		return newCheckRule;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCheckRule();
	}
}
