package com.bokesoft.yigo.meta.datamigration.calculate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.bokesoft.yigo.common.def.DataGroupGranularity;
import com.bokesoft.yigo.common.def.MigrationUpdateStrategyType;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationCheckRule;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

/**
 * 迁移表定义
 * 
 * @author 刘翔翔
 *
 */
public class MetaMigrationTable {

	/** 迁移表的KEY */
	private String key = null;

	/** 数据库表的标识 */
	private String dbTableName = "";

	/** 标注 */
	private String tag = null;

	/** 分组字段 */
	private ArrayList<MetaColumnM> groupColumnList = new ArrayList<>();

	/** 值字段 */
	private ArrayList<MetaColumnM> dataColumnList = new ArrayList<>();

	/** 期间字段 */
	private MetaPeriodColumn periodColumn = null;

	/** 迁移检查规则 */
	private List<MetaMigrationCheckRule> checkRuleList = new ArrayList<>();

	/** 迁移表更新数据时使用的策略 */
	private int migrationUpdateStrategy = MigrationUpdateStrategyType.INSERT_FAST;

	//// 计算得出

	/** 值更新方式(以源数据对象为) */
	private HashMap<String, MetaMigrationTableParas> parasMap = new HashMap<>();

	public void init(MetaDataObject dataObject) {
		MetaTable targetMetaTable = dataObject.getTableCollection().get(0);
		migrationUpdateStrategy = dataObject.getMigrationUpdateStrategy();
		if (dataObject.getMigrationCheckRuleCollection() != null)
			for (MetaMigrationCheckRule rule : dataObject.getMigrationCheckRuleCollection())
				checkRuleList.add(rule);

		for (MetaColumn column : targetMetaTable) {
			if (!column.isPersist() || column.isSystemControlField())
				continue;

			MetaColumnM mc = null;
			if (column.getGroupType() == DataGroupGranularity.Period) {
				periodColumn = new MetaPeriodColumn();
				periodColumn.setPeriodGranularity(column.getPeriodGranularity());
				periodColumn.setPeriodImpl(column.getPeriodImpl());
				periodColumn.setSplitType(column.getSplitType());
				mc = periodColumn;
			} else {
				mc = new MetaColumnM();
			}

			mc.setDataType(column.getDataType());
			mc.setDbColumnName(column.getDBColumnName());
			mc.setKey(column.getKey());

			if (column.isGroup())
				groupColumnList.add(mc);
			else
				dataColumnList.add(mc);
		}

		tag = dataObject.getCaption() == null ? "" : dataObject.getCaption() + "(" + dataObject.getKey() + ")";
	}

	public List<MetaMigrationCheckRule> getCheckRuleList() {
		return checkRuleList;
	}

	public MetaPeriodColumn getPeriodColumn() {
		return periodColumn;
	}

	public ArrayList<MetaColumnM> getGroupColumnList() {
		return groupColumnList;
	}

	public ArrayList<MetaColumnM> getDataColumnList() {
		return dataColumnList;
	}

	public void put(String key, MetaDataMigration migration, IMetaFactory metaFactory) throws Throwable {
		MetaMigrationTableParas paras = parasMap.get(key);
		if (paras == null) {
			paras = new MetaMigrationTableParas(this);
			parasMap.put(key, paras);
		}
		paras.init(migration, metaFactory);
	}

	public MetaMigrationTableParas getMetaMigrationTableParas(String srcKey) {
		return parasMap.get(srcKey);
	}

	public String getTag() {
		return tag;
	}

	public int getMigrationUpdateStrategy() {
		return migrationUpdateStrategy;
	}

	public String getKey() {
		return key;
	}

	/**
	 * 取得绑定的数据表的标识
	 * 
	 * @return 如果dbTableName不为空，返回dbTableName，否则返回key
	 */
	public String getBindingDBTableName() {
		return (dbTableName != null && !dbTableName.isEmpty()) ? dbTableName : key;
	}

}
