package com.bokesoft.yigo.meta.datamigration;

/**
 * 值处理方式(操作符号),取值如下：
 * <ul>
 * <li>OP_ADD_DELTA 加变化值，常量不支持该处理方式
 * <li>OP_ADD_VALUE 加直接量
 * <li>OP_ASSIGN 赋直接值
 * </ul>
 * 
 */
public class DMOpSign {
	/** 加变化值 */
	public static final int OP_ADD_DELTA = 0;
	/** 加变化值字符串表示 */
	public static final String STR_OP_ADD_DELTA = "AddDelta";

	/** 加直接量 */
	public static final int OP_ADD_VALUE = 1;
	/** 加直接量字符串表示 */
	public static final String STR_OP_ADD_VALUE = "AddValue";

	/** 直接赋值 */
	public static final int OP_ASSIGN = 2;
	/** 直接赋值字符串表示 */
	public static final String STR_OP_ASSIGN = "Assign";
	
	public static int parse(String s) {
		int sign = -1;
		if ( STR_OP_ADD_DELTA.equalsIgnoreCase(s) ) {
			sign = OP_ADD_DELTA;
		} else if ( STR_OP_ADD_VALUE.equalsIgnoreCase(s) ) {
			sign = OP_ADD_VALUE;
		} else if ( STR_OP_ASSIGN.equalsIgnoreCase(s) ) {
			sign = OP_ASSIGN;
		}
		return sign;
	}
	
	public static String toString(Integer sign) {
		if(sign == null)
			return "";
		
		String s = null;
		switch ( sign ) {
		case OP_ADD_DELTA:
			s = STR_OP_ADD_DELTA;
			break;
		case OP_ADD_VALUE:
			s = STR_OP_ADD_VALUE;
			break;
		case OP_ASSIGN:
			s = STR_OP_ASSIGN;
			break;
		}
		return s;
	}
}
