package com.bokesoft.yigo.meta.datamap.calculate;

import java.util.ArrayList;
import java.util.HashMap;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;

/**
 * 一个映射边的涉及的内容
 * 
 * @author 刘翔翔
 *
 */
public class MetaMapEdge {

	/** 映射边源表 */
	private String sourceTableKey;

	/** 映射边目标表 */
	private String targetTableKey;

	/** 主源表以上所有的父表的标识集合 */
	private ArrayList<String> sourceTableList = null;

	/** 主目标表以上所有的父表的标识集合 */
	private ArrayList<String> targetTableList = null;

	/** 映射边目标中涉及的所有表 */
	private HashMap<String, MetaMapEdge> childEdgeMap = new HashMap<String, MetaMapEdge>();

	/** 在有父映射边的情况下，它的父映射边是否为单据的主表 */
	private boolean mainTableParent = false;

	public MetaMapEdge(String sourceTableKey) {
		this.sourceTableKey = sourceTableKey;
	}

	public void searchEdgeMap(MetaMap dataMap, MetaDataObject srcDataObject, MetaDataObject tgtDataObject) {
		MetaSourceTable sourceTable = dataMap.getSourceTableCollection().get(sourceTableKey);
		if (sourceTable == null) {
			throw new MetaException(MetaException.MAP_PRIMARY_TABLE_NOT_SET, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MapPrimaryTableNotSet), dataMap.getKey()));
		}
		
		targetTableKey = sourceTable.getTargetTableKey();
		sourceTableList = searchTableList(srcDataObject, sourceTableKey);
		targetTableList = searchTableList(tgtDataObject, targetTableKey);
	}

	private ArrayList<String> searchTableList(MetaDataObject dataObject, String tableKey) {
		ArrayList<String> orginList = new ArrayList<String>();
		while (tableKey != null && tableKey.length() > 0) {
			orginList.add(0, tableKey);
			tableKey = dataObject.getMetaTable(tableKey).getParentKey();
		}
		return orginList;
	}

	public ArrayList<String> getSourceTableList() {
		return sourceTableList;
	}

	public ArrayList<String> getTargetTableList() {
		return targetTableList;
	}

	public void putChildEdgeList(MetaMapEdge edge) {
		childEdgeMap.put(edge.getSourceTableKey(), edge);
	}

	public String getSourceTableKey() {
		return sourceTableKey;
	}

	public HashMap<String, MetaMapEdge> getChildEdgeMap() {
		return childEdgeMap;
	}

	public String getTargetTableKey() {
		return targetTableKey;
	}

	public boolean isMainTableParent() {
		return mainTableParent;
	}

	public void setMainTableParent(boolean mainTableParent) {
		this.mainTableParent = mainTableParent;
	}
}
