package com.bokesoft.yigo.meta.commondef;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaComponentSetting;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaMigrationExtensionCollection;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.commondef.extend.MetaCommonDefCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSourceCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSourceCollection;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRuleCollection;

public class MetaCommonDef extends KeyPairMetaObject  implements IElementMerge<MetaCommonDef>{
	private String scope =  "";

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	/** 公共操作定义集合 */
	private MetaOperationCollection operationCollection = null;
	/** 状态集合 */
	private MetaStatusCollection statusCollection = null;
	/** 脚本集合 */
	private MetaScriptCollection scriptCollection = null;
	/** 组件设置 */
	private MetaComponentSetting componentSetting = null;
	/** 宏公式 */
	private MetaMacroCollection macroCollection = null;
	/** 查询集合 */
	private MetaQueryCollection queryCollection = null;
	/** 检查规则集合 */
	private MetaCheckRuleCollection checkRuleCollection = null;
	/** searchBoxProvoder集合*/
	private MetaSearchBoxProviderCollection searchBoxProviderCollection =  null;
	/** 迁移的扩展属性设置*/
	private MetaMigrationExtensionCollection migrationExtensionCollection = null;
	/** 字体库源定义*/
	private MetaIconFontSourceCollection iconFontSourceCollection = null;
	/** 图标源定义*/
	private MetaIconSourceCollection iconSourceCollection = null;

	private String solutionKey;
	public MetaCommonDef() {
		super();
	}

	@Override
	public String getKey() {
		return scope;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(operationCollection);
		list.add(statusCollection);
		list.add(scriptCollection);
		list.add(macroCollection);
		list.add(queryCollection);
		list.add(checkRuleCollection);
		list.add(searchBoxProviderCollection);
		list.add(migrationExtensionCollection);
		list.add(iconFontSourceCollection);
		list.add(iconSourceCollection);
	}

	/**
	 * 设置操作定义集合
	 * @param operationCollection 操作定义集合
	 */
	public void setOperationCollection(MetaOperationCollection operationCollection) {
		this.operationCollection = operationCollection;
	}

	/**
	 * 取得操作定义集合
	 * @return 操作定义集合
	 */
	public MetaOperationCollection getOperationCollection() {
		return this.operationCollection;
	}

	/**
	 * 设置状态定义集合
	 * @param statusCollection 状态定义集合
	 */
	public void setStatusCollection(MetaStatusCollection statusCollection) {
		this.statusCollection = statusCollection;
	}

	/**
	 * 取得状态定义集合
	 * @return 状态定义集合
	 */
	public MetaStatusCollection getStatusCollection() {
		return this.statusCollection;
	}

	/**
	 * 设置脚本集合
	 * @param scriptCollection 脚本集合
	 */
	public void setScriptCollection(MetaScriptCollection scriptCollection) {
		this.scriptCollection = scriptCollection;
	}

	/**
	 * 取得脚本集合
	 * @return 脚本集合
	 */
	public MetaScriptCollection getScriptCollection() {
		return this.scriptCollection;
	}

	/**
	 * 设置组件设置
	 * @param componentSetting 组件设置
	 */
	public void setComponentSetting(MetaComponentSetting componentSetting) {
		this.componentSetting = componentSetting;
	}

	/**
	 * 取得组件设置
	 * @return 组件设置
	 */
	public MetaComponentSetting getComponentSetting() {
		return this.componentSetting;
	}

	/**
	 * 设置宏公式集合
	 * @param macroCollection 宏公式集合
	 */
	public void setMacroCollection(MetaMacroCollection macroCollection) {
		this.macroCollection = macroCollection;
	}

	/**
	 * 取得宏公式集合
	 * @return 宏公式集合
	 */
	public MetaMacroCollection getMacroCollection() {
		return this.macroCollection;
	}

	/**
	 * 设置查询集合
	 * @param queryCollection 查询集合
	 */
	public void setQueryCollection(MetaQueryCollection queryCollection) {
		this.queryCollection = queryCollection;
	}

	/**
	 * 取得查询集合
	 * @return 查询集合
	 */
	public MetaQueryCollection getQueryCollection() {
		return this.queryCollection;
	}

	public MetaIconFontSourceCollection getIconFontSourceCollection() {
		return iconFontSourceCollection;
	}

	public void setIconFontSourceCollection(MetaIconFontSourceCollection iconFontSourceCollection) {
		this.iconFontSourceCollection = iconFontSourceCollection;
	}

	public MetaIconSourceCollection getIconSourceCollection() {
		return iconSourceCollection;
	}

	public void setIconSourceCollection(MetaIconSourceCollection iconSourceCollection) {
		this.iconSourceCollection = iconSourceCollection;
	}

	public MetaCheckRuleCollection getCheckRuleCollection() {
		return checkRuleCollection;
	}

	public void setCheckRuleCollection(MetaCheckRuleCollection checkRuleCollection) {
		this.checkRuleCollection = checkRuleCollection;
	}

	public MetaSearchBoxProviderCollection getSearchBoxProviderCollection() {
		return searchBoxProviderCollection;
	}

	public void setSearchBoxProviderCollection(MetaSearchBoxProviderCollection searchBoxProviderCollection) {
		this.searchBoxProviderCollection = searchBoxProviderCollection;
	}


	public MetaMigrationExtensionCollection getMigrationExtensionCollection() {
		return migrationExtensionCollection;
	}

	public void setMigrationExtensionCollection(MetaMigrationExtensionCollection migrationExtensionCollection) {
		this.migrationExtensionCollection = migrationExtensionCollection;
	}

	public String getSolutionKey() {
		return solutionKey;
	}

	public void setSolutionKey(String solutionKey) {
		this.solutionKey = solutionKey;
	}

	public static final String TAG_NAME = "CommonDef";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaOperationCollection.TAG_NAME.equals(tagName) ) {
			this.operationCollection = new MetaOperationCollection();
			resultMetaObject = operationCollection;
		} else if ( MetaStatusCollection.TAG_NAME.equals(tagName) ) {
			this.statusCollection = new MetaStatusCollection();
			resultMetaObject = statusCollection;
		} else if ( MetaScriptCollection.TAG_NAME.equals(tagName) ) {
			this.scriptCollection = new MetaScriptCollection();
			resultMetaObject = scriptCollection;
		} else if ( MetaComponentSetting.TAG_NAME.equals(tagName) ) {
			this.componentSetting = new MetaComponentSetting();
			resultMetaObject = componentSetting;
		} else if ( MetaMacroCollection.TAG_NAME.equals(tagName) ) {
			this.macroCollection = new MetaMacroCollection();
			resultMetaObject = macroCollection;
		} else if ( MetaQueryCollection.TAG_NAME.equals(tagName) ) {
			this.queryCollection = new MetaQueryCollection();
			resultMetaObject = this.queryCollection;
		} else if (MetaCheckRuleCollection.TAG_NAME.equals(tagName)) {
			this.checkRuleCollection = new MetaCheckRuleCollection();
			resultMetaObject = checkRuleCollection;
		} else if (MetaSearchBoxProviderCollection.TAG_NAME.equals(tagName)) {
			this.searchBoxProviderCollection = new MetaSearchBoxProviderCollection();
			resultMetaObject = searchBoxProviderCollection;
		} else if (MetaMigrationExtensionCollection.TAG_NAME.equals(tagName)) {
			this.migrationExtensionCollection = new MetaMigrationExtensionCollection();
			resultMetaObject = migrationExtensionCollection;
		} else if (MetaIconFontSourceCollection.TAG_NAME.equals(tagName)) {
			this.iconFontSourceCollection = new MetaIconFontSourceCollection();
			resultMetaObject = iconFontSourceCollection;
		} else if (MetaIconSourceCollection.TAG_NAME.equals(tagName)) {
			this.iconSourceCollection = new MetaIconSourceCollection();
			resultMetaObject = iconSourceCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCommonDef newObject = new MetaCommonDef();
		newObject.setOperationCollection(operationCollection == null ? null : (MetaOperationCollection)operationCollection.clone());
		newObject.setStatusCollection(statusCollection == null ? null : (MetaStatusCollection)statusCollection.clone());
		newObject.setScriptCollection(scriptCollection == null ? null : (MetaScriptCollection)scriptCollection.clone());
		newObject.setComponentSetting(componentSetting == null ? null : (MetaComponentSetting)componentSetting.clone());
		newObject.setMacroCollection(macroCollection == null ? null : (MetaMacroCollection)macroCollection.clone());
		newObject.setQueryCollection(queryCollection == null ? null : (MetaQueryCollection)queryCollection.clone());
		newObject.setCheckRuleCollection(checkRuleCollection == null ? null : (MetaCheckRuleCollection)checkRuleCollection.clone());
		newObject.setSearchBoxProviderCollection(searchBoxProviderCollection == null ? null : (MetaSearchBoxProviderCollection)searchBoxProviderCollection.clone());
		newObject.setIconFontSourceCollection(iconFontSourceCollection == null ? null : (MetaIconFontSourceCollection)iconFontSourceCollection.clone());
		newObject.setIconSourceCollection(iconSourceCollection == null ? null : (MetaIconSourceCollection)iconSourceCollection.clone());

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCommonDef();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if ( operationCollection != null ) {
			operationCollection.doPostProcess(flag, callback);
		}
		if ( statusCollection != null ) {
			statusCollection.doPostProcess(flag, callback);
		}
		if ( scriptCollection != null ) {
			scriptCollection.doPostProcess(flag, callback);
		}
		if( queryCollection != null ) {
			queryCollection.doPostProcess(flag, callback);
		}

		if (this.iconFontSourceCollection != null) {
			for (int i = 0; i < this.iconFontSourceCollection.size(); i++) {
				MetaIconFontSource source = this.iconFontSourceCollection.get(i);
				source.setSolutionKey(this.solutionKey);
			}
			this.iconFontSourceCollection.doPostProcess(flag, callback);

		}

		if (this.iconSourceCollection != null) {
			for (int i = 0; i < this.iconSourceCollection.size(); i++) {
				MetaIconSource source = this.iconSourceCollection.get(i);
				source.setSolutionKey(solutionKey);
			}
			this.iconSourceCollection.doPostProcess(flag, callback);
		}
	}

	private MetaMacroCollection toMergeMacroCollection(MetaMacroCollection mac1, MetaMacroCollection mac2) {
		MetaMacroCollection mac3 = null;
		if (mac2 != null) {
			if (mac1 != null) {
				Iterator<MetaMacro> it = mac2.iterator();
				MetaMacro macro = null;
				MetaMacro macro1 = null;

				while (it.hasNext()) {
					macro = it.next();

					macro1 = mac1.get(macro.getKey());
					if (macro1 != null) {
						macro1.merge(macro);
					} else {
						mac1.add((MetaMacro) macro.clone());
					}
				}
				mac3 = mac1;
			} else {
				mac3 = (MetaMacroCollection) mac2.clone();
			}
		}
		return mac3;
	}

	private MetaStatusCollection toMergeStatusCollection(MetaStatusCollection statuses1, MetaStatusCollection statuses2) {
		MetaStatusCollection statusCollection = null;
		if (statuses2 != null) {
			if (statuses1 != null) {
				Iterator<MetaStatus> it = statuses2.iterator();
				MetaStatus status = null;
				MetaStatus status1 = null;

				while (it.hasNext()) {
					status = it.next();

					status1 = statuses1.get(status.getKey());
					if (status1 != null) {
						if (status.getCaption() == null) {
							status1.setCaption(status.getCaption());
						}
						if (status.getValue() == null) {
							status1.setValue(status.getValue());
						}
					} else {
						statuses1.add((MetaStatus) status.clone());
					}
				}
				statusCollection = statuses1;
			} else {
				statusCollection = (MetaStatusCollection) statuses2.depthClone();
			}
		}
		return statusCollection;
	}
	@Override
	public MetaCommonDef toMerge(MetaCommonDef obj) {
		if (this.getOperationCollection() != null) {
			this.getOperationCollection().merge(obj.getOperationCollection());
		}
		if (this.getMacroCollection() != null) {
			this.setMacroCollection(toMergeMacroCollection(this.getMacroCollection(), obj.getMacroCollection()));
		}
		if (this.getStatusCollection() != null) {
			this.setStatusCollection(toMergeStatusCollection(this.getStatusCollection(), obj.getStatusCollection()));
		}
		return this;
	}
}
