package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * MetaVar定义变量的值，Yigo中的变量指以${key}这样的形式定义的标识。
 * @author wangyh
 *
 */
public class MetaVar extends KeyPairMetaObject implements IPropertyMerger<MetaVar> {
	/** 变量标识 */
	private String key = "";
	/** 变量的值 */
	private String value = "";
	
	public MetaVar() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Var";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 设置变量标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得变量标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置变量的值
	 * @param value 值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/**
	 * 取得变量的值
	 * @return 值
	 */
	public String getValue() {
		return this.value;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaVar newObject = (MetaVar)newInstance();
		newObject.setKey(key);
		newObject.setValue(value);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaVar();
	}

	@Override
	public void merge(MetaVar metaVar) {

		if (this.value == null){
			this.value = metaVar.getValue();
		}
	}
}