package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaProcess定义中间层服务扩展处理流中的处理步骤，包括描述和实现类(全路径名)
 * @author 王元和
 *
 */
public class MetaMidProcess extends AbstractMetaObject {
	/** 描述 */
	private String description = "";
	/** 实现类名(全路径名) */
	private String impl = "";
	/** 处理时机 */
	private String time = "";
	
	public MetaMidProcess() {
		super();
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置实现类名
	 * @param impl 实现类名
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 取得实现类名
	 * @return 实现类名
	 */
	public String getImpl() {
		return this.impl;
	}
	
	/**
	 * 设置时机
	 * @param time 时机
	 */
	public void setTime(String time) {
		this.time = time;
	}
	
	/**
	 * 取得时机
	 * @return 时机
	 */
	public String getTime() {
		return this.time;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "MidProcess";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMidProcess newObject = new MetaMidProcess();
		newObject.setDescription(description);
		newObject.setImpl(impl);
		newObject.setTime(time);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMidProcess();
	}

}
