package com.bokesoft.yigo.meta.charging;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaChargingTargetObject定义计费的输出目标
 * @author wangyh
 *
 */
public class MetaChargingTargetObject extends GenericNoKeyCollection<MetaChargingTargetField> {
	/** 仅插入 */
	public static final int ONLY_INSERT = 0;
	public static final String STR_ONLY_INSERT = "OnlyInsert";
	
	/** 更新优先 */
	public static final int UPDATE_FIRST = 1;
	public static final String STR_UPDATE_FIRST = "UpdateFirst";
	
	/** 分组后更新优先 */
	public static final int GROUP_ONLY_INSERT = 2;
	public static final String STR_GROUP_ONLY_INSERT = "GroupOnlyInsert";
	
	/** 数据对象标识 */
	private String objectKey = "";
	/** 表标识 */
	private String tableKey = "";
	/** 目标生成策略 */
	private Integer policy = UPDATE_FIRST;
	
	public MetaChargingTargetObject() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	public static final String TAG_NAME = "TargetObject";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置数据对象标识
	 * @param objectKey 数据对象标识
	 */
	public void setObjectKey(String objectKey) {
		this.objectKey = objectKey;
	}
	
	/**
	 * 取得数据对象标识
	 * @return 数据对象标识
	 */
	public String getObjectKey() {
		return this.objectKey;
	}
	
	/**
	 * 设置表标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得表标识
	 * @return 表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}
	
	/**
	 * 设置目标生成策略
	 * @param policy 生成策略
	 */
	public void setPolicy(Integer policy) {
		this.policy = policy;
	}
	
	/**
	 * 取得目标生成策略
	 * @return 生成策略
	 */
	public Integer getPolicy() {
		return this.policy;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaChargingTargetField.TAG_NAME.equals(tagName) ) {
			MetaChargingTargetField field = new MetaChargingTargetField();
			this.add(field);
			resultMetaObject = field;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaChargingTargetObject newObject = (MetaChargingTargetObject)newInstance();
		newObject.setObjectKey(objectKey);
		newObject.setTableKey(tableKey);
		newObject.setPolicy(policy);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingTargetObject();
	}

	public static int parsePolicy(String s) {
		int policy = -1;
		if ( STR_ONLY_INSERT.equalsIgnoreCase(s) ) {
			policy = ONLY_INSERT;
		} else if ( STR_UPDATE_FIRST.equalsIgnoreCase(s) ) {
			policy = UPDATE_FIRST;
		} else if ( STR_GROUP_ONLY_INSERT.equalsIgnoreCase(s) ) {
			policy = GROUP_ONLY_INSERT;
		}
		return policy;
	}
	
	public static String toPolicyString(Integer policy) {
		if(policy == null) {
			return "";
		}
		String s = "";
		switch ( policy ) {
		case ONLY_INSERT:
			s = STR_ONLY_INSERT;
			break;
		case UPDATE_FIRST:
			s = STR_UPDATE_FIRST;
			break;
		case GROUP_ONLY_INSERT:
			s = STR_GROUP_ONLY_INSERT;
			break;
		}
		return s;
	}
}
