package com.bokesoft.yigo.meta.charging;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaChargingTargetField定义计费目标的字段信息
 * @author wangyh
 *
 */
public class MetaChargingTargetField extends AbstractMetaObject {
	/** 来源于字段 */
	public static final int SRC_TYPE_FIELD = 0;
	public static final String STR_SRC_TYPE_FIELD = "Field";
	
	/** 来源于表达式 */
	public static final int SRC_TYPE_FORMULA = 1;
	public static final String STR_SRC_TYPE_FORMULA = "Formula";
	
	/** 来源于计算结果 */
	public static final int SRC_TYPE_RESULT = 2;
	public static final String STR_SRC_TYPE_RESULT = "Result";
	
	/** 覆盖赋值 */
	public static final int ASSIGN_TYPE_OVERWRITE = 0;
	public static final String STR_ASSIGN_TYPE_OVERWRITE = "Overwirte";
	
	/** 增加 */
	public static final int ASSIGN_TYPE_ADD = 1;
	public static final String STR_ASSIGN_TYPE_ADD = "Add";
	
	/** 来源类型 */
	private Integer srcType = SRC_TYPE_FIELD;
	/** 源字段标识 */
	private String srcFieldKey = "";
	/** 来源表达式 */
	private String formula = "";
	/** 目标字段标识 */
	private String tgtFieldKey = "";
	/** 是否主键 */
	private Boolean isPK = false;
	/** 赋值方式 */
	private Integer assignType = ASSIGN_TYPE_OVERWRITE;
	
	public MetaChargingTargetField() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}
	
	public static final String TAG_NAME = "TargetField";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置来源类型
	 * @param srcType 来源类型
	 */
	public void setSrcType(Integer srcType) {
		this.srcType = srcType;
	}
	
	/**
	 * 取得来源类型
	 * @return 来源类型
	 */
	public Integer getSrcType() {
		return this.srcType;
	}
	
	/**
	 * 设置源字段标识
	 * @param srcFieldKey 源字段标识
	 */
	public void setSrcFieldKey(String srcFieldKey) {
		this.srcFieldKey = srcFieldKey;
	}
	
	/**
	 * 取得源字段标识
	 * @return 源字段标识
	 */
	public String getSrcFieldKey() {
		return this.srcFieldKey;
	}
	
	/**
	 * 设置来源表达式
	 * @param formula 来源表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	/**
	 * 取得来源表达式
	 * @return 来源表达式
	 */
	public String getFormula() {
		return this.formula;
	}
	
	/**
	 * 设置目标字段标识
	 * @param tgtFieldKey 目标字段标识
	 */
	public void setTgtFieldKey(String tgtFieldKey) {
		this.tgtFieldKey = tgtFieldKey;
	}
	
	/**
	 * 取得目标字段标识
	 * @return 目标字段标识
	 */
	public String getTgtFieldKey() {
		return this.tgtFieldKey;
	}
	
	/**
	 * 设置是否主键
	 * @param isPK 主键标志
	 */
	public void setIsPK(Boolean isPK) {
		this.isPK = isPK;
	}
	
	/**
	 * 取得是否主键
	 * @return 主键标志
	 */
	public Boolean isPK() {
		return this.isPK;
	}
	
	/**
	 * 设置赋值方式
	 * @param assignType 赋值方式
	 */
	public void setAssignType(Integer assignType) {
		this.assignType = assignType;
	}
	
	/**
	 * 取得赋值方式
	 * @return 赋值方式
	 */
	public Integer getAssignType() {
		return this.assignType;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaChargingTargetField newObject = (MetaChargingTargetField)newInstance();
		newObject.setSrcType(srcType);
		newObject.setSrcFieldKey(srcFieldKey);
		newObject.setFormula(formula);
		newObject.setTgtFieldKey(tgtFieldKey);
		newObject.setIsPK(isPK);
		newObject.setAssignType(assignType);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingTargetField();
	}

	public static int parseSrcType(String s) {
		int srcType = -1;
		if ( STR_SRC_TYPE_FIELD.equalsIgnoreCase(s) ) {
			srcType = SRC_TYPE_FIELD;
		} else if ( STR_SRC_TYPE_FORMULA.equalsIgnoreCase(s) ) {
			srcType = SRC_TYPE_FORMULA;
		} else if ( STR_SRC_TYPE_RESULT.equalsIgnoreCase(s) ) {
			srcType = SRC_TYPE_RESULT;
		}
		return srcType;
	}
	
	public static String toSrcTypeString(int srcType) {
		String s = "";
		switch ( srcType ) {
		case SRC_TYPE_FIELD:
			s = STR_SRC_TYPE_FIELD;
			break;
		case SRC_TYPE_FORMULA:
			s = STR_SRC_TYPE_FORMULA;
			break;
		case SRC_TYPE_RESULT:
			s = STR_SRC_TYPE_RESULT;
			break;
		}
		return s;
	}
	
	public static int parseAssignType(String s) {
		int assignType = -1;
		if ( STR_ASSIGN_TYPE_OVERWRITE.equalsIgnoreCase(s) ) {
			assignType = ASSIGN_TYPE_OVERWRITE;
		} else if ( STR_ASSIGN_TYPE_ADD.equalsIgnoreCase(s) ) {
			assignType = ASSIGN_TYPE_ADD;
		}
		
		return assignType;
	}
	
	public static String toAssignTypeString(Integer assignType) {
		if(assignType == null)
			return "";
		
		String s = "";
		switch ( assignType ) {
		case ASSIGN_TYPE_OVERWRITE:
			s = STR_ASSIGN_TYPE_OVERWRITE;
			break;
		case ASSIGN_TYPE_ADD:
			s = STR_ASSIGN_TYPE_ADD;
			break;
		}
		return s;
	}
}
