package com.bokesoft.yigo.meta.charging;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaChargingRule定义计费规则，计费规则由两部分组成，一部分是计费规则，
 * 另外一部分是计费表达式，计费针对一个计费对象扫描一个计费规则组中的所有计费规则，找到第一个满足条件的计费规则计算其计费表达式，
 * 以确定计费的最终结果。
 * @author wangyh
 *
 */
public class MetaChargingRule extends AbstractCompositeObject {
	/** 规则 */
	public static final int RULE = 0;
	/** 集合 */
	public static final int COLLECTION = 1;
	
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 描述 */
	private String description = "";
	/** 条件 */
	private MetaChargingRuleCondition condition = null;
	/** 表达式 */
	private MetaChargingRuleExpression expression = null;
	
	public MetaChargingRule() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, condition, expression);
	}

	public static final String TAG_NAME = "ChargingRule";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaChargingRuleCondition.TAG_NAME.equals(tagName) ) {
			this.condition = new MetaChargingRuleCondition();
			resultMetaObject = this.condition;
		} else if ( MetaChargingRuleExpression.TAG_NAME.equals(tagName) ) {
			this.expression = new MetaChargingRuleExpression();
			resultMetaObject = this.expression;
		}
		
		return resultMetaObject;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置条件
	 * @param condition 条件
	 */
	public void setCondition(MetaChargingRuleCondition condition) {
		this.condition = condition;
	}
	
	/**
	 * 取得条件
	 * @return 条件
	 */
	public MetaChargingRuleCondition getCondition() {
		return this.condition;
	}
	
	/**
	 * 设置表达式
	 * @param expression 表达式
	 */
	public void setExpression(MetaChargingRuleExpression expression) {
		this.expression = expression;
	}
	
	/**
	 * 取得表达式
	 * @return 表达式
	 */
	public MetaChargingRuleExpression getExpression() {
		return this.expression;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaChargingRule newObject = (MetaChargingRule)newInstance();
		newObject.setCondition(condition == null ? null :(MetaChargingRuleCondition)condition.clone());
		newObject.setExpression(expression == null ? null : (MetaChargingRuleExpression)expression.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingRule();
	}

	@Override
	public int getCompositeType() {
		return RULE;
	}

}
