package com.bokesoft.yigo.meta.bpm.process.node;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

/**
 * 多人任务节点
 * 
 * @author 刘翔翔
 *
 */
public class MetaMultiUserTask extends MetaUserTask {

	/** 节点的标签 */
	public final static String TAG_NAME = "MultiUserTask";

	/** 是否顺序执行 */
	private Boolean inOrder = false;

	/**
	 * 获取是否顺序执行
	 * 
	 * @return 是否顺序执行标志
	 */
	public Boolean isInOrder() {
		return inOrder;
	}

	/**
	 * 设置是否顺序执行
	 * 
	 * @param inOrder 是否顺序执行的布尔值标志
	 */
	public void setInOrder(Boolean inOrder) {
		this.inOrder = inOrder;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMultiUserTask newObj = (MetaMultiUserTask) super.clone();
		newObj.setInOrder(inOrder);
		return newObj;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMultiUserTask();
	}

	@Override
	public int getNodeType() {
		return NodeType.MULTI_USER_TASK;
	}

}
