package com.bokesoft.yigo.meta.bpm.process.attribute.timer;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaTimerItem extends AbstractTimer {

	public static final String TAG_NAME = "TimerItem";

	private String trigger;

	private Boolean repeat = false;
	/** 超时循环执行的时间间隔*/
	private String cycleInterval = null;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTimerItem();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTimerItem newTimerItem = (MetaTimerItem) super.clone();
		newTimerItem.setTrigger(trigger);
		newTimerItem.setRepeat(repeat);
		return newTimerItem;
	}

	public String getTrigger() {
		return trigger;
	}

	public void setTrigger(String trigger) {
		this.trigger = trigger;
	}

	public Boolean isRepeat() {
		return repeat;
	}

	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}

	public String getCycleInterval() {
		return cycleInterval;
	}

	public void setCycleInterval(String cycleInterval) {
		this.cycleInterval = cycleInterval;
	}
	

}
