package com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;

public class MetaExtendItem extends MetaItems {
	
	public static final String TAG_NAME = "ExtendItem";
	
	private String path = "";
	private MetaSourceParaCollection metaSourceParaCollection = null;
	
	public void setPath(String path) {
		this.path = path;
	}
	
	public String getPath(){
		return path;
	}
	
	public void setSourceParaCollection(MetaSourceParaCollection metaSourceParaCollection) {
		this.metaSourceParaCollection = metaSourceParaCollection;
	}
	
	public MetaSourceParaCollection getSourceParaCollection() {
		return metaSourceParaCollection;
	}
	
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { metaSourceParaCollection });
	}
	
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaSourceParaCollection.TAG_NAME)) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			resultMetaObject = metaSourceParaCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaExtendItem meta = (MetaExtendItem)super.clone();
		meta.setPath(path);
		meta.setSourceParaCollection(metaSourceParaCollection == null ? null : (MetaSourceParaCollection) metaSourceParaCollection.clone());
		return meta;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtendItem();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = super.toJSON();
		obj.put("path", path);
		if(metaSourceParaCollection != null) {
			obj.put("metaSourceParaCollection", metaSourceParaCollection);
		}
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		super.fromJSON(json);
		path = json.optString("path");
		if (json.has("metaSourceParaCollection")) {
			metaSourceParaCollection = new MetaSourceParaCollection();
			metaSourceParaCollection.fromJSON(json.getJSONObject("metaSourceParaCollection"));
		}
	}
}
