package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaDictionary extends Participator {

	public final static String TAG_NAME = "Dictionary";

	/** 字典的KEY，当前仅支持操作员和角色 */
	private String dictionaryKey = "";

	/** 字典的ID，支持若干个以"ID1:ID2:ID3"的形式存储 */
	private String itemID = "";
	
	/** 字典的CODE，支持若干个以"CODE1:CODE2:CODE3"的形式存储 */
	private String code="";

	public String getDictionaryKey() {
		return dictionaryKey;
	}

	public void setDictionaryKey(String dictionaryKey) {
		this.dictionaryKey = dictionaryKey;
	}

	public String getItemID() {
		return itemID;
	}

	public void setItemID(String itemID) {
		this.itemID = itemID;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDictionary newDictionary = (MetaDictionary) newInstance();
		newDictionary.setDictionaryKey(dictionaryKey);
		newDictionary.setItemID(itemID);
		newDictionary.setCode(this.code);
		return newDictionary;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictionary();
	}

}
