package com.bokesoft.yigo.meta.bpm.process.attachment;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 附件对象的集合
 * 
 * @author 刘翔翔
 *
 */
public class MetaAttachmentCollection extends GenericKeyCollection<MetaAttachment> {

	public static final String TAG = "AttachmentCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaAttachment.TAG.equals(tagName)) {
			MetaAttachment perm = new MetaAttachment();
			perm.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(perm);
			resultMetaObject = perm;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAttachmentCollection();
	}

}
