package com.bokesoft.yigo.meta.bpm.process.attachment;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaItem;

/**
 * 附件对象
 * 
 * @author 刘翔翔
 *
 */
public class MetaAttachment extends MetaItem {

	public static final String TAG = "Attachment";

	/** 附件对象的名称 */
	private String caption = "";

	/** 附件的类型 */
	private Integer type = AttachmentType.BILL;

	/** 附件的参数 */
	private String para = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaAttachment at = new MetaAttachment();
		at.setCaption(caption);
		at.setKey(getKey());
		at.setPara(para);
		at.setType(type);
		return at;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAttachment();
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getPara() {
		return para;
	}

	public void setPara(String para) {
		this.para = para;
	}

}
