package com.bokesoft.yigo.meta.bpm.process.attachment;

/**
 * 节点附件的处理模式
 * 
 * @author 刘翔翔
 *
 */
public class AttachmentOperateType {

	/** 普通 */
	public static final int NORMAL = 0;
	public static final String NORMAL_TAG = "Normal";

	/** 新增 */
	public static final int NEW = 1;
	public static final String NEW_TAG = "New";

	public static int parse(String s) {
		int type = -1;
		if (NORMAL_TAG.equalsIgnoreCase(s)) {
			type = NORMAL;
		} else if (NEW_TAG.equalsIgnoreCase(s)) {
			type = NEW;
		}
		return type;
	}

	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = null;
		switch (type) {
		case NORMAL:
			s = NORMAL_TAG;
			break;
		case NEW:
			s = NEW_TAG;
			break;
		}
		return s;
	}

}
